/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

CxpNote *cxpnote;

struct
{
	GdkColor color;
	gchar *name;
} text_colors[] =
{
	{
		{
	0, 0x0000, 0x0000, 0x0000}, "black"},
	{
		{
	0, 0xFFFF, 0xFFFF, 0xFFFF}, "white"},
	{
		{
	0, 0xFFFF, 0x0000, 0x0000}, "red"},
	{
		{
	0, 0x0000, 0xFFFF, 0x0000}, "green"},
	{
		{
	0, 0x0000, 0x0000, 0xFFFF}, "blue"},
	{
		{
	0, 0x0000, 0xFFFF, 0xFFFF}, "cyan"},
	{
		{
	0, 0xFFFF, 0x0000, 0xFFFF}, "magenta"},
	{
		{
	0, 0xFFFF, 0xFFFF, 0x0000}, "yellow"}
};

#define	COLOR_BLACK	0
#define	COLOR_WHITE	1
#define	COLOR_RED	2
#define	COLOR_GREEN	3
#define	COLOR_BLUE	4
#define	COLOR_CYAN	5
#define	COLOR_MAGENTA	6
#define	COLOR_YELLOW	7

int ntext_colors = sizeof (text_colors) / sizeof (text_colors[0]);

int cxpnoteFileOpen ()
{
	FILE *fp;
	char buffer[1024];
	char wbuffer[1024];
	char workname[1024];
	int nchars;
	char *ptr;

	int i, j, k;
	int comment;		/* ȥե饰 */

	/* ƥȤɤ߹ */
	if (!access (cxpnote->filename, F_OK))
	{
		gtk_text_freeze (GTK_TEXT (cxpnote->text));
		fp = fopen (cxpnote->filename, "r");

		if (fp)
		{

			comment = 0;
			while (1)
			{
				memset (buffer, 0x00, sizeof (buffer));
				if (fgets (buffer, sizeof (buffer), fp) !=
				    NULL)
				{
					ptr = (char *) strrchr (buffer, '\r');
					if (ptr != NULL)
					{
						*ptr = '\n';
						*(ptr + 1) = 0x00;
					}
					nchars = strlen (buffer);

					if (cxpnote->color == 0)
					{
						gtk_text_insert (GTK_TEXT
								 (cxpnote->
								  text),
								 cxpnote->
								 font, NULL,
								 NULL, buffer,
								 nchars);
					}
					else
					{
						/* ޤ¸ʳ (^_^; */
						j = 0;
						memset (wbuffer, 0x00,
							sizeof (wbuffer));
						for (i = 0; i < nchars; i++)
						{
							if (comment == 0)
							{
								if (strncmp
								    (buffer,
								     "#",
								     1) == 0)
								{
									for (k
									     =
									     0;
									     k
									     <
									     nchars;
									     k++)
									{
										if (strncmp (&buffer[k], "/*", 2) != 0)
										{
											wbuffer[j] = buffer[k];
											j++;
										}
										else
										{
											break;
										}
									}
									if (j
									    >
									    0)
									{
										gtk_text_insert
											(GTK_TEXT
											 (cxpnote->
											  text),
											 cxpnote->
											 font,
											 &text_colors
											 [COLOR_MAGENTA].
											 color,
											 NULL,
											 wbuffer,
											 j);
										j = 0;
									}
									i = k;
									continue;
								}
							}

							if (comment == 0)
							{
								if (strncmp
								    (&buffer
								     [i],
								     "/*",
								     2) == 0)
								{
									if (j
									    >
									    0)
									{
										gtk_text_insert
											(GTK_TEXT
											 (cxpnote->
											  text),
											 cxpnote->
											 font,
											 &text_colors
											 [COLOR_BLACK].
											 color,
											 NULL,
											 wbuffer,
											 j);
									}

									j = 0;
									wbuffer[j] = '/';
									j++;
									wbuffer[j] = '*';
									j++;
									i++;
									comment = 1;
									continue;
								}
							}
							else if (comment == 1)
							{
								if (strncmp
								    (&buffer
								     [i],
								     "*/",
								     2) == 0)
								{
									wbuffer[j] = '*';
									j++;
									wbuffer[j] = '/';
									j++;

									gtk_text_insert
										(GTK_TEXT
										 (cxpnote->
										  text),
										 cxpnote->
										 font,
										 &text_colors
										 [COLOR_BLUE].
										 color,
										 NULL,
										 wbuffer,
										 j);

									j = 0;
									i++;

									comment = 0;
									continue;
								}
							}
							wbuffer[j] =
								buffer[i];
							j++;
						}

						if (j > 0)
						{
							if (comment == 0)
							{
								gtk_text_insert
									(GTK_TEXT
									 (cxpnote->
									  text),
									 cxpnote->
									 font,
									 &text_colors
									 [COLOR_BLACK].
									 color,
									 NULL,
									 wbuffer,
									 j);
							}
							else
							{
								gtk_text_insert
									(GTK_TEXT
									 (cxpnote->
									  text),
									 cxpnote->
									 font,
									 &text_colors
									 [COLOR_BLUE].
									 color,
									 NULL,
									 wbuffer,
									 j);
							}
						}
					}
				}
				else
				{
					break;
				}
			}
			fclose (fp);
		}
		else
		{
			/* ɤ߹ߥ顼 */
			messageView ("ɤ߹ߥ顼", "", "Ĥ",
				     "ե륪ץ˼Ԥޤ",
				     cxpnote->filename, NULL);
		}
		gtk_text_thaw (GTK_TEXT (cxpnote->text));
	}

	cxpnote_titleview ();

}

int cxpnoteFileWrite ()
{
	FILE *fp;
	char *dataptr;
	int size;
	char workbuff[1024];
	char checkname[1024];
	char *ptr;
	int status, icnt;

	strcpy (workbuff, cxpnote->filename);
	ptr = strrchr (workbuff, '/');
	*ptr = 0x00;

	if (strlen (workbuff) <= 0)
		sprintf (checkname, "/.");
	else
		sprintf (checkname, "%s/.", workbuff);

	status = checkPermission (checkname, cxpnote->uid, cxpnote->gid);
	if (status != 0)
	{
		/* 񤭹ߵĤʤ */
		messageView ("¸顼", "", "Ĥ",
			     "ޤ",
			     cxpnote->filename, NULL);

		return (-1);
	}

	/* ƥȤν񤭹 */
	dataptr =
		gtk_editable_get_chars (GTK_EDITABLE (cxpnote->text), 0, -1);

#ifdef DEBUG
	fprintf (stdout, "size    -> [%d]\n", strlen (dataptr));
	fprintf (stdout, "dataptr -> [%s]\n", dataptr);
#endif

	fp = fopen (cxpnote->filename, "w");

	if (fp)
	{
		size = strlen (dataptr);
		ptr = dataptr;
		for (icnt = 0; icnt < size; icnt++)
		{
			if (EOF == fputc (*ptr, fp))
				break;
			ptr++;
		}

		fclose (fp);

		if (icnt != strlen (dataptr))
		{
			g_free (dataptr);

			/* ¸˼ */
			messageView ("¸顼", "", "Ĥ",
				     "ե¸˼Ԥޤ",
				     cxpnote->filename, NULL);
			return (-1);
		}
		g_free (dataptr);

		return (0);

	}
	else
	{
		g_free (dataptr);
		/* ¸˼ */
		messageView ("¸顼", "", "Ĥ",
			     "ե¸˼Ԥޤ",
			     cxpnote->filename, NULL);
		return (-1);
	}

}

int cxpnoteCheckFile ()
{
	FILE *fp;
	int cc;
	char *dataptr;
	int count;
	int status;
	int maxlength;

	gtk_text_freeze (GTK_TEXT (cxpnote->text));
	gtk_text_set_point (GTK_TEXT (cxpnote->text), 0);
	maxlength = gtk_text_get_length (GTK_TEXT (cxpnote->text));


	count = 0;
	status = 0;

	if (strcmp (cxpnote->filename, "NewFile") == 0 && maxlength == 0)
		return (status);

	fp = fopen (cxpnote->filename, "r");
	if (fp)
	{
		while (1)
		{
			cc = fgetc (fp);
			if (cc != EOF)
			{
				if ((char) cc == '\r')
					continue;

				dataptr =
					gtk_editable_get_chars (GTK_EDITABLE
								(cxpnote->
								 text), count,
								count + 1);
				count++;

				if ((char) cc != *dataptr)
				{
					status++;
					break;
				}
			}
			else
			{
				break;
			}
		}
		fclose (fp);
		if (maxlength - count > 0)
			status++;
	}
	else
	{
		status++;
	}
	gtk_text_thaw (GTK_TEXT (cxpnote->text));


	return (status);
}
