/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

extern CxpNote *cxpnote;

static int fontIndex;

static char *clist_title[1] = {
	"ե̾"
};

static void clist_unselection (clist, row, column, event, data)
     GtkWidget *clist;
     gint row;
     gint column;
     GdkEventButton *event;
     gpointer data;
{
	/* 򥯥ꥢ */
	fontIndex = -1;
}

static void clist_selection (clist, row, column, event, data)
     GtkWidget *clist;
     gint row;
     gint column;
     GdkEventButton *event;
     gpointer data;
{
	int i;

	if (row < 0)
		return;

	/* ˥å */
	fontIndex = row;

	return;
}

static void setfunc (GtkWidget * widget, gpointer data)
{
	GtkStyle *style;
	GdkFont *font;
	GtkText *textMain;
	GtkTextFont *textfont;
	char savename[1024];
	char fontbuff[1024];
	int status;
	int i;
	int ypoint;

	if (fontIndex < 0)
	{
		/* եȤꤵƤޤ */
		return;
	}

	/* ե */
	cxpnote->fontIndex = fontIndex;

	sprintf (fontbuff, "%s,%s,%s",
		 cxpnote->fontInfo.font[fontIndex].font_alpha,
		 cxpnote->fontInfo.font[fontIndex].font_kanji,
		 cxpnote->fontInfo.font[fontIndex].font_kana);

#ifdef	DEBUG
	fprintf (stdout, "fontIndex -> [%d]\n", cxpnote->fontIndex);
	fprintf (stdout, "    [%s]\n", fontbuff);
	fflush (stdout);
#endif

	/* ߤΥɤ߹ */
	style = gtk_style_copy (gtk_widget_get_style (cxpnote->window));

	gdk_font_unref (style->font);
	style->font = gdk_fontset_load (fontbuff);	/* ե */
	cxpnote->font = gdk_fontset_load (fontbuff);	/* ե */
	gdk_font_ref (style->font);
	gtk_widget_set_style (cxpnote->text, style);
	gtk_widget_set_style (cxpnote->window, style);

	/* ƥȥꥢ */
	gtk_text_freeze (GTK_TEXT (cxpnote->text));

	/* ߤΥƥȰ֤ */
	ypoint = gtk_text_get_point (GTK_TEXT (cxpnote->text));

	/* ߤΥƥȾ¸ */
	strcpy (savename, cxpnote->filename);
	sprintf (cxpnote->filename, "/tmp/.cxpnote_%04x", cxpnote->pid);
	cxpnoteFileWrite ();

	/* ֤Ƭذư */
	gtk_text_set_point (GTK_TEXT (cxpnote->text), 0);

	/* ƬǸޤǥǡ */
	gtk_text_forward_delete (GTK_TEXT (cxpnote->text),
				 gtk_text_get_length (GTK_TEXT
						      (cxpnote->text)));

	/* ¸ƥȤɤ߹ */
	cxpnoteFileOpen ();
	strcpy (cxpnote->filename, savename);

	/* ֤Ƹ */
	gtk_text_set_point (GTK_TEXT (cxpnote->text), ypoint);

	/* ƥȥꥢ */
	gtk_text_thaw (GTK_TEXT (cxpnote->text));

	/* ե */
	sprintf (savename, "/tmp/.cxpnote_%04x", cxpnote->pid);
	remove (savename);

	/* ȥ򹹿 */
	cxpnote_titleview ();

	/* ˴ */
	gtk_widget_hide (cxpnote->fontdlg);
	cxpnote->fontdlg = NULL;

}

static void canfunc (GtkWidget * widget, gpointer data)
{
	gtk_widget_hide (cxpnote->fontdlg);
	cxpnote->fontdlg = NULL;
}


void cxpnote_fontlist_init ()
{
	GtkWidget *setbtn;
	GtkWidget *canbtn;
	GtkWidget *label;
	int x, y, w, h;
	int i;
	char *fontname[2];

	gdk_window_get_origin (cxpnote->window->window, &x, &y);
	gdk_window_get_size (cxpnote->window->window, &w, &h);

	cxpnote->fontdlg = gtk_dialog_new ();
	gtk_window_set_title (GTK_WINDOW (cxpnote->fontdlg), "եѹ");

	gtk_widget_set_usize (cxpnote->fontdlg, 300, 230);
	gtk_widget_set_uposition (cxpnote->fontdlg,
				  (x + (w / 2)) - (300 / 2),
				  (y + (h / 2)) - (230 / 2));
	gtk_widget_show (cxpnote->fontdlg);

	setbtn = gtk_button_new_with_label ("");
	gtk_signal_connect_object (GTK_OBJECT (setbtn), "clicked",
				   (GtkSignalFunc) setfunc, NULL);
	gtk_box_pack_start (GTK_BOX
			    (GTK_DIALOG (cxpnote->fontdlg)->action_area),
			    setbtn, TRUE, TRUE, 5);
	gtk_widget_show (setbtn);

	canbtn = gtk_button_new_with_label ("Ĥ");
	gtk_signal_connect_object (GTK_OBJECT (canbtn), "clicked",
				   (GtkSignalFunc) canfunc, NULL);
	gtk_box_pack_start (GTK_BOX
			    (GTK_DIALOG (cxpnote->fontdlg)->action_area),
			    canbtn, TRUE, TRUE, 5);
	gtk_widget_show (canbtn);


	label = gtk_label_new ("ե");
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (cxpnote->fontdlg)->vbox),
			    label, FALSE, FALSE, 5);
	gtk_widget_show (label);


	/* Clist Τ뤿Υɥɥ */
	cxpnote->fontswin = gtk_scrolled_window_new (NULL, NULL);

	/* ʿӿľΥСɽ褦 */
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW
					(cxpnote->fontswin),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (cxpnote->fontdlg)->vbox),
			    cxpnote->fontswin, TRUE, TRUE, 5);
	gtk_widget_show (cxpnote->fontswin);

	cxpnote->fontlist = gtk_clist_new_with_titles (1, clist_title);

	gtk_widget_set_usize (cxpnote->fontlist, 200, -1);
	gtk_clist_set_selection_mode (GTK_CLIST (cxpnote->fontlist),
				      GTK_SELECTION_BROWSE);

	gtk_signal_connect (GTK_OBJECT (cxpnote->fontlist),
			    "select_row", GTK_SIGNAL_FUNC (clist_selection),
			    NULL);

	gtk_signal_connect (GTK_OBJECT (cxpnote->fontlist),
			    "unselect_row",
			    GTK_SIGNAL_FUNC (clist_unselection), NULL);

	/* ȥܥȤʤ褦ˤ롣 */
	gtk_clist_column_titles_passive (GTK_CLIST (cxpnote->fontlist));

	gtk_container_add (GTK_CONTAINER (cxpnote->fontswin),
			   cxpnote->fontlist);
	gtk_widget_show (cxpnote->fontlist);

	/* եȥꥹȤ˥ե̾ */
	for (i = 0; i < cxpnote->fontInfo.kensu; i++)
	{
		fontname[0] = g_strdup (cxpnote->fontInfo.font[i].title);
		gtk_clist_append (GTK_CLIST (cxpnote->fontlist), fontname);
	}

	/* ֤ */
	fontIndex = cxpnote->fontIndex;
	if (fontIndex >= 0)
	{
		gtk_clist_select_row (GTK_CLIST (cxpnote->fontlist),
				      fontIndex, 0);
	}


}
