/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

extern CxpNote *cxpnote;
extern int cxpnoteFileWrite ();

static GtkWidget *filew;
static int saveMode;

static void nofunc (GtkWidget * widget, gpointer data)
{
	gtk_widget_hide (widget);
}

void cxpnote_newfunc ()
{
	system ("cxpnote");
}

static int _cxpnote_openfunc (GtkWidget * widget, GtkFileSelection * fs)
{
	/* ƥȥꥢ */
	gtk_text_freeze (GTK_TEXT (cxpnote->text));

	/* ֤Ƭذư */
	gtk_text_set_point (GTK_TEXT (cxpnote->text), 0);

	/* ƬǸޤǥǡ */
	gtk_text_forward_delete (GTK_TEXT (cxpnote->text),
				 gtk_text_get_length (GTK_TEXT
						      (cxpnote->text)));

	/* ե뤫ɤ߹ */
	strcpy (cxpnote->filename,
		gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)));
	cxpnoteFileOpen ();

	/* ֤Ƭذư */
	gtk_text_set_point (GTK_TEXT (cxpnote->text), 0);

	/* ƥȥꥢ */
	gtk_text_thaw (GTK_TEXT (cxpnote->text));

	gtk_widget_hide (filew);

	gtk_widget_hide (cxpnote->text);
	gtk_widget_show (cxpnote->text);

	return (0);
}

static int _cxpnote_open2func (GtkWidget * widget, GtkFileSelection * fs)
{
	char workbuff[1024];

	sprintf (workbuff, "cxpnote \"%s\"",
		 gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)));
	system (workbuff);

	gtk_widget_hide (filew);

	return (0);
}

static int _cxpnote_writefunc (GtkWidget * widget, GtkFileSelection * fs)
{
	int status;

	if (widget != (GtkWidget *) NULL)
	{
		strcpy (cxpnote->filename,
			gtk_file_selection_get_filename (GTK_FILE_SELECTION
							 (fs)));
	}

	gtk_window_set_title (GTK_WINDOW (cxpnote->window),
			      cxpnote->filename);

	/* ե˽ */
	status = cxpnoteFileWrite ();

	if (widget != (GtkWidget *) NULL)
	{
		gtk_widget_hide (filew);
		return (TRUE);
	}

	return (FALSE);
}

void cxpnote_mess_ok ()
{
	filew = gtk_file_selection_new ("եɤ߹");

	gtk_signal_connect (GTK_OBJECT (filew), "destroy",
			    (GtkSignalFunc) gtk_widget_destroy,
			    GTK_OBJECT (filew));
	gtk_signal_connect (GTK_OBJECT
			    (GTK_FILE_SELECTION (filew)->ok_button),
			    "clicked", (GtkSignalFunc) _cxpnote_openfunc,
			    filew);
	gtk_signal_connect_object (GTK_OBJECT
				   (GTK_FILE_SELECTION (filew)->
				    cancel_button), "clicked",
				   (GtkSignalFunc) gtk_widget_destroy,
				   GTK_OBJECT (filew));

	gtk_widget_show (filew);
}

void cxpnote_openfunc ()
{
	int status;

	status = cxpnoteCheckFile ();
	if (status)
	{
		messageView ("եɹٹ", "ɹ", "",
			     "ե뤬ѹƤޤ",
			     "Ǥɤ߹ߤޤ", cxpnote_mess_ok);
	}
	else
	{
		filew = gtk_file_selection_new ("եɤ߹");

		gtk_signal_connect (GTK_OBJECT (filew), "destroy",
				    (GtkSignalFunc) gtk_widget_destroy,
				    GTK_OBJECT (filew));
		gtk_signal_connect (GTK_OBJECT
				    (GTK_FILE_SELECTION (filew)->ok_button),
				    "clicked",
				    (GtkSignalFunc) _cxpnote_openfunc, filew);
		gtk_signal_connect_object (GTK_OBJECT
					   (GTK_FILE_SELECTION (filew)->
					    cancel_button), "clicked",
					   (GtkSignalFunc) gtk_widget_destroy,
					   GTK_OBJECT (filew));

		gtk_widget_show (filew);
	}
}

void cxpnote_open2func ()
{

	filew = gtk_file_selection_new ("եɤ߹");

	gtk_signal_connect (GTK_OBJECT (filew), "destroy",
			    (GtkSignalFunc) gtk_widget_destroy,
			    GTK_OBJECT (filew));
	gtk_signal_connect (GTK_OBJECT
			    (GTK_FILE_SELECTION (filew)->ok_button),
			    "clicked", (GtkSignalFunc) _cxpnote_open2func,
			    filew);
	gtk_signal_connect_object (GTK_OBJECT
				   (GTK_FILE_SELECTION (filew)->
				    cancel_button), "clicked",
				   (GtkSignalFunc) gtk_widget_destroy,
				   GTK_OBJECT (filew));

	gtk_widget_show (filew);
}


void cxpnote_write2func ()
{
	filew = gtk_file_selection_new ("ե¸");

	gtk_signal_connect (GTK_OBJECT (filew), "destroy",
			    (GtkSignalFunc) gtk_widget_destroy, filew);
	gtk_signal_connect (GTK_OBJECT
			    (GTK_FILE_SELECTION (filew)->ok_button),
			    "clicked", (GtkSignalFunc) _cxpnote_writefunc,
			    filew);
	gtk_signal_connect_object (GTK_OBJECT
				   (GTK_FILE_SELECTION (filew)->
				    cancel_button), "clicked",
				   (GtkSignalFunc) gtk_widget_destroy,
				   GTK_OBJECT (filew));

	if (strcmp (cxpnote->filename, "NewFile") == 0)
	{
		gtk_file_selection_set_filename (GTK_FILE_SELECTION (filew),
						 "untitle.txt");
	}
	else
	{
		gtk_file_selection_set_filename (GTK_FILE_SELECTION (filew),
						 cxpnote->filename);
	}

	gtk_widget_show (filew);
}

void cxpnote_writefunc ()
{
	if (strcmp (cxpnote->filename, "NewFile") == 0)
	{
		cxpnote_write2func ();
	}
	else
	{
		_cxpnote_writefunc ((GtkWidget *) NULL,
				    (GtkFileSelection *) NULL);
	}
}

void cxpnore_mess_exitok ()
{
	g_free (cxpnote);

	gtk_main_quit ();
}

void cxpnote_closefunc ()
{
	int status;
	int x, y, w, h;
	int gx, gy, gw, gh;
	int xymode, whmode;

	getGeometryInfo (CXPNOTE_MODE, &xymode, &whmode, &x, &y, &w, &h);

	gdk_window_get_position (cxpnote->window->window, &gx, &gy);
	gdk_window_get_size (cxpnote->window->window, &gw, &gh);

	if (xymode == 0)	/* ΰ */
	{
		x = gx;
		y = gy;
	}
	if (whmode == 0)	/* Υ */
	{
		w = gw;
		h = gh;
	}

	setGeometryInfo (CXPNOTE_MODE, xymode, whmode, x, y, w, h);

	status = cxpnoteCheckFile ();
	if (status)
	{
		messageView ("λǧ", "λ", "",
			     "ե뤬ѹƤޤ",
			     "Ǥ⽪λޤ", cxpnore_mess_exitok);
	}
	else
	{

		/* CxpNoteνλ */
		g_free (cxpnote);

		gtk_main_quit ();
	}
}

void cxpnote_copyfunc ()
{
	/* ԡ */
	gtk_editable_copy_clipboard (GTK_EDITABLE (cxpnote->text));

}

void cxpnote_pastefunc ()
{
	/* ڡ */
	gtk_editable_paste_clipboard (GTK_EDITABLE (cxpnote->text));
}

void cxpnote_fontfunc ()
{
	if (cxpnote->fontdlg != NULL)
	{
		gtk_widget_hide (cxpnote->fontdlg);
	}

	cxpnote_fontlist_init ();
}

void cxpnote_colorfunc ()
{
	cxpnote_color_dialog ("", "", "Ĥ");
}


void cxpnote_helpfunc ()
{
	cxpnote_help ();
}
