/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

/*
 * Cxplorer for UNIX Version Header
 *
 * version    date         log
 * 1.0.0      1999/08/21   first release
 * 1.0.1      1999/09/05   menu accel add.
 * 1.0.2      1999/09/10   bug fix.
 * 1.0.3      1999/10/01   dos file(CR/LF) supported.
 * 1.0.4      1999/10/16   original font sel dlg add.
 * 1.1.0      1999/11/20   file open add. (open/open2)
 *                         dos file(CR/LF) bug fix.
 *                         file close/open save dlg add.
 * 1.2.0      2000/02/28   color mode add. review menu add.
 * 1.2.1      2000/04/07   cxpnote [filename] open error bug fix.
 * 1.2.2      2000/04/17   main exit code is ZERO add.
 * 1.2.3      2000/04/20   GNOME application Drag and Drop supported
 *                         (Thanks Patch File Masahiro Sakai)
 * 1.2.4      2000/05/16   Window size save.
 * 1.2.5      2000/06/28   window manager destroy event support.
 * 1.2.6      2000/08/03   cxpmanager start add.
 *                         view size setting add.
 *
 *
 */

extern CxpNote *cxpnote;

static char *Version = "С 1.2.6 2000/08/03";
static char *Website = "http://www1.sphere.ne.jp/hatakeda";
static char *Email = "Ϣ衧 hatakeda@mbm.sphere.ne.jp";
static char *Copyright = "Copyright 1998-2000 Konta";
static char *Kakunin = "Ĥ";

static void helpdialog_destroy (GtkWidget * widget, gpointer data)
{
	/* ɥϥɤ */
	gtk_grab_remove (widget);
	gtk_widget_hide (widget);
}

void cxpnote_help ()
{
	GtkWidget *dialog;
	GtkWidget *label[5];
	GtkWidget *button;
	GtkWidget *pixmapwid;
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	GtkStyle *style;
	int x, y, w, h;

	gdk_window_get_origin (cxpnote->window->window, &x, &y);
	gdk_window_get_size (cxpnote->window->window, &w, &h);

	dialog = gtk_dialog_new ();
#ifdef	CXP_ENGLISH
	gtk_window_set_title (GTK_WINDOW (dialog), "About Cxpnote");
#else
	gtk_window_set_title (GTK_WINDOW (dialog), "CxpnoteˤĤ");
#endif
	gtk_widget_set_usize (dialog, 300, 210);
	gtk_widget_set_uposition (dialog, (x + (w / 2)) - (300 / 2),
				  (y + (h / 2)) - (210 / 2));
	gtk_grab_add (dialog);
	gtk_widget_show (dialog);

	label[4] = gtk_label_new (Copyright);
	gtk_box_pack_end (GTK_BOX (GTK_DIALOG (dialog)->vbox),
			  label[4], FALSE, TRUE, 5);
	gtk_widget_show (label[4]);

	label[3] = gtk_label_new (Email);
	gtk_box_pack_end (GTK_BOX (GTK_DIALOG (dialog)->vbox),
			  label[3], FALSE, TRUE, 5);
	gtk_widget_show (label[3]);

	label[2] = gtk_label_new (Website);
	gtk_box_pack_end (GTK_BOX (GTK_DIALOG (dialog)->vbox),
			  label[2], FALSE, TRUE, 5);
	gtk_widget_show (label[2]);

	label[1] = gtk_label_new (Version);
	gtk_box_pack_end (GTK_BOX (GTK_DIALOG (dialog)->vbox),
			  label[1], FALSE, TRUE, 5);
	gtk_widget_show (label[1]);

	style = gtk_widget_get_style (cxpnote->window);
	pixmap = gdk_pixmap_create_from_xpm (cxpnote->window->window,
					     &mask,
					     &style->bg[GTK_STATE_NORMAL],
					     cxpnote->base.cxpnote);
	pixmapwid = gtk_pixmap_new (pixmap, mask);
	gtk_box_pack_end (GTK_BOX (GTK_DIALOG (dialog)->vbox),
			  pixmapwid, TRUE, TRUE, 0);
	gtk_widget_show (pixmapwid);


	button = gtk_button_new_with_label (Kakunin);
	gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
				   (GtkSignalFunc) helpdialog_destroy,
				   GTK_OBJECT (dialog));

	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area),
			    button, FALSE, TRUE, 0);
	gtk_widget_show (button);

}
