/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

extern CxpNote *cxpnote;

static void filemenu_response ();
static void editmenu_response ();
static void viewmenu_response ();
static void settmenu_response ();
static void helpmenu_response ();

#define	FILEIACT_NEWFILE	0x0101
#define	FILEIACT_OPEN		0x0102
#define	FILEIACT_OPEN2		0x0103
#define	FILEIACT_WRITE		0x0104
#define	FILEIACT_WRITE2		0x0105
#define	FILEIACT_SEP1		0x0106
#define	FILEIACT_CLOSE		0x0107
#define	EDITIACT_COPY		0x0201
#define	EDITIACT_PASTE		0x0202
#define	SETTIACT_SETVIEW	0x0301
#define	VIEWIACT_FONT		0x0401
#define	VIEWIACT_COLOR		0x0402
#define	VIEWIACT_VIEW		0x0403
#define	HELPIACT_ABOUT		0x0501


#define	FILEMENU_BASE		"/ե"
#define	FILEMENU_NEWFILE	"/ե/"
#define	FILEMENU_OPEN		"/ե/ե򳫤"
#define	FILEMENU_OPEN2		"/ե/ե򳫤"
#define	FILEMENU_WRITE		"/ե/¸"
#define	FILEMENU_WRITE2		"/ե/̾դ¸"
#define	FILEMENU_SEP1		"/ե/sep1"
#define	FILEMENU_CLOSE		"/ե/Ĥ"

#define	EDITMENU_BASE		"/Խ"
#define	EDITMENU_COPY		"/Խ/ԡ"
#define	EDITMENU_PASTE		"/Խ/Žդ"

#define	SETTMENU_BASE		"/"
#define	SETTMENU_SETVIEW	"//ɽ֡"

#define	VIEWMENU_BASE		"/ɽ"
#define	VIEWMENU_FONT		"/ɽ/եѹ"
#define	VIEWMENU_COLOR		"/ɽ/"
#define	VIEWMENU_VIEW		"/ɽ/ɽ"

#define	HELPMENU_BASE		"/إ"
#define	HELPMENU_ABOUT		"/إ/CxpnoteˤĤ"

static GtkItemFactoryEntry menu_items[] = {
	{FILEMENU_BASE, NULL, NULL, 0, "<Branch>"},
	{FILEMENU_NEWFILE, "<control>N", filemenu_response, FILEIACT_NEWFILE,
	 NULL},
	{FILEMENU_OPEN, "<control>O", filemenu_response, FILEIACT_OPEN, NULL},
	{FILEMENU_OPEN2, "<control>I", filemenu_response, FILEIACT_OPEN2,
	 NULL},
	{FILEMENU_WRITE, "<control>S", filemenu_response, FILEIACT_WRITE,
	 NULL},
	{FILEMENU_WRITE2, NULL, filemenu_response, FILEIACT_WRITE2, NULL},
	{FILEMENU_SEP1, NULL, NULL, 0, "<Separator>"},
	{FILEMENU_CLOSE, "<control>Q", filemenu_response, FILEIACT_CLOSE,
	 NULL},
	{EDITMENU_BASE, NULL, NULL, 0, "<Branch>"},
	{EDITMENU_COPY, "<control>C", editmenu_response, EDITIACT_COPY, NULL},
	{EDITMENU_PASTE, "<control>V", editmenu_response, EDITIACT_PASTE,
	 NULL},
	{SETTMENU_BASE, NULL, NULL, 0, "<Branch>"},
	{SETTMENU_SETVIEW, NULL, settmenu_response, SETTIACT_SETVIEW, NULL},
	{VIEWMENU_BASE, NULL, NULL, 0, "<Branch>"},
	{VIEWMENU_FONT, "<control>F", viewmenu_response, VIEWIACT_FONT, NULL},
	{VIEWMENU_COLOR, NULL, viewmenu_response, VIEWIACT_COLOR, NULL},
	{VIEWMENU_VIEW, "<control>L", viewmenu_response, VIEWIACT_VIEW, NULL},
	{HELPMENU_BASE, NULL, NULL, 0, "<LastBranch>"},
	{HELPMENU_ABOUT, NULL, helpmenu_response, HELPIACT_ABOUT, NULL},
};


static void filemenu_response (GtkWidget * w, gpointer data)
{
	switch ((int) data)
	{
	case FILEIACT_NEWFILE:
		cxpnote_newfunc ();
		break;
	case FILEIACT_OPEN:
		cxpnote_openfunc ();
		break;
	case FILEIACT_OPEN2:
		cxpnote_open2func ();
		break;
	case FILEIACT_WRITE:
		cxpnote_writefunc ();
		break;
	case FILEIACT_WRITE2:
		cxpnote_write2func ();
		break;
	case FILEIACT_CLOSE:
		cxpnote_closefunc ();
		break;
	}
}
static void editmenu_response (GtkWidget * w, gpointer data)
{
	switch ((int) data)
	{
	case EDITIACT_COPY:
		cxpnote_copyfunc ();
		break;
	case EDITIACT_PASTE:
		cxpnote_pastefunc ();
		break;
	}
}
static void settmenu_response (GtkWidget * w, gpointer data)
{
	switch ((int) data)
	{
	case SETTIACT_SETVIEW:
		create_sizeSettingWindow (CXPNOTE_MODE);
		break;
	}
}
static void viewmenu_response (GtkWidget * w, gpointer data)
{
	switch ((int) data)
	{
	case VIEWIACT_FONT:
		cxpnote_fontfunc ();
		break;
	case VIEWIACT_COLOR:
		cxpnote_colorfunc ();
		break;
	case VIEWIACT_VIEW:
		cxpnote_viewfunc ();
		break;
	}
}
static void helpmenu_response (GtkWidget * w, gpointer data)
{
	switch ((int) data)
	{
	case HELPIACT_ABOUT:
		cxpnote_helpfunc ();
		break;
	}
}


void cxpnote_menu_init ()
{
	GtkWidget *handle_box;
	GtkWidget *subitem;
	GtkItemFactory *item_factory;
	GtkAccelGroup *accel_group;
	int nmenu_items = sizeof (menu_items) / sizeof (menu_items[0]);

	handle_box = gtk_handle_box_new ();
	gtk_box_pack_start (GTK_BOX (cxpnote->vbox), handle_box, FALSE, FALSE,
			    0);
	gtk_widget_show (handle_box);

	accel_group = gtk_accel_group_new ();

	item_factory =
		gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>",
				      accel_group);

	gtk_item_factory_create_items (item_factory, nmenu_items, menu_items,
				       NULL);

	gtk_accel_group_attach (accel_group, GTK_OBJECT (cxpnote->window));

	cxpnote->menubar =
		gtk_item_factory_get_widget (item_factory, "<main>");
	gtk_container_add (GTK_CONTAINER (handle_box), cxpnote->menubar);
	gtk_widget_show (cxpnote->menubar);

}
