/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

extern CxpNote *cxpnote;

static gboolean eventKeyid = 0;
static guint start_position = -1;
static guint end_position = -1;

static gboolean event_watcher_press (GtkObject * object,
				     guint sigid, guint n_params,
				     GtkArg * params, gpointer data)
{
	gchar *dataptr;

	if ((GtkWidget *) object != (GtkWidget *) cxpnote->text)
		return;

	start_position = gtk_text_get_point (GTK_TEXT (cxpnote->text));
	end_position = -1;

	return TRUE;
}

static gboolean event_watcher_release (GtkObject * object,
				       guint sigid, guint n_params,
				       GtkArg * params, gpointer data)
{
	guint position;
	gchar *dataptr;

	if ((GtkWidget *) object != (GtkWidget *) cxpnote->text)
		return;

	end_position = gtk_text_get_point (GTK_TEXT (cxpnote->text));

	if (start_position > end_position)
	{
		g_print ("[back code] : ");
	}
	else if (abs (end_position - start_position) == 1)
	{
		g_print ("[normal   ] : ");
	}
	else
	{
		g_print ("[mouse  in] : ");
	}
	g_print ("start -> %d   end -> %d\n", start_position, end_position);

/*******
  dataptr = gtk_editable_get_chars( GTK_EDITABLE(cxpnote->text),
			start_position, end_position );
  g_free(dataptr);
*********/

	return TRUE;
}


void cxpnote_text_init ()
{
	GtkWidget *table;
	GtkWidget *vscrollbar;
	guint sigid;

	table = gtk_table_new (2, 2, FALSE);
	gtk_table_set_row_spacing (GTK_TABLE (table), 0, 2);
	gtk_table_set_col_spacing (GTK_TABLE (table), 0, 2);
	gtk_box_pack_start (GTK_BOX (cxpnote->vbox), table, TRUE, TRUE, 5);
	gtk_widget_show (table);

	/* GtkText åȤ */
	cxpnote->text = gtk_text_new (NULL, NULL);
	gtk_text_set_editable (GTK_TEXT (cxpnote->text), TRUE);
	gtk_table_attach (GTK_TABLE (table), cxpnote->text, 0, 1, 0, 1,
			  GTK_EXPAND | GTK_SHRINK | GTK_FILL,
			  GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show (cxpnote->text);

	/* GtkText åȤ˿ľСɲ */
	vscrollbar = gtk_vscrollbar_new (GTK_TEXT (cxpnote->text)->vadj);
	gtk_table_attach (GTK_TABLE (table), vscrollbar, 1, 2, 0, 1,
			  GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show (vscrollbar);

	/* åȤμβǥɥ뤳Ȥǡƥ */
	gtk_widget_realize (cxpnote->text);

#if 0				/* ޤ¸ʳ (^_^; */

	sigid = gtk_signal_lookup ("key_press_event", GTK_TYPE_WIDGET);
	eventKeyid = gtk_signal_add_emission_hook (sigid,
						   event_watcher_press, NULL);
	sigid = gtk_signal_lookup ("key_release_event", GTK_TYPE_WIDGET);
	eventKeyid = gtk_signal_add_emission_hook (sigid,
						   event_watcher_release,
						   NULL);

#endif

}
