/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

extern CxpNote *cxpnote;

static char *toolbar_title[12] = {
	"",
	"¸",
	"ԡ",
	"Ž",
};

static char *toolbar_tooltip[12] = {
	"եޤ",
	"ǥ¸ޤ",
	"򤷤ǡ򥳥ԡޤ",
	"ԡǡŽդޤ",
};

static void toolbar_function0 (GtkWidget * widget, gpointer data)
{
	/*  */
	cxpnote_newfunc ();
}
static void toolbar_function1 (GtkWidget * widget, gpointer data)
{
	/* ¸ */
	cxpnote_writefunc ();
}
static void toolbar_function2 (GtkWidget * widget, gpointer data)
{
	/* ԡ */
	cxpnote_copyfunc ();
}
static void toolbar_function3 (GtkWidget * widget, gpointer data)
{
	/* Ž */
	cxpnote_pastefunc ();
}

void cxpnote_topcmd_init ()
{
	GtkWidget *handle_box;
	GtkWidget *vbox;
	GtkWidget *toolbar;
	GtkWidget *pixmapwid;
	GtkWidget *item;
	GtkWidget *separator;
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	GtkStyle *style;

	int i;

	handle_box = gtk_handle_box_new ();
	gtk_box_pack_start (GTK_BOX (cxpnote->vbox), handle_box, FALSE, TRUE,
			    0);
	gtk_widget_show (handle_box);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (handle_box), vbox);
	gtk_widget_show (vbox);

	separator = gtk_hseparator_new ();
	gtk_box_pack_start (GTK_BOX (vbox), separator, FALSE, TRUE, 0);
	gtk_widget_show (separator);

	toolbar =
		gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL,
				 GTK_TOOLBAR_BOTH);
	gtk_box_pack_start (GTK_BOX (vbox), toolbar, FALSE, FALSE, 0);
	gtk_toolbar_set_button_relief (GTK_TOOLBAR (toolbar),
				       GTK_RELIEF_NONE);
	gtk_widget_show (toolbar);

	separator = gtk_hseparator_new ();
	gtk_box_pack_start (GTK_BOX (vbox), separator, FALSE, TRUE, 0);
	gtk_widget_show (separator);

	style = gtk_widget_get_style (cxpnote->window);

	for (i = 0; i < 4; i++)
	{
		pixmap = gdk_pixmap_create_from_xpm (cxpnote->window->window,
						     &mask,
						     &style->
						     bg[GTK_STATE_NORMAL],
						     cxpnote->base.note[i]);
		pixmapwid = gtk_pixmap_new (pixmap, mask);

		switch (i)
		{
		case 0:
			item = gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),
							toolbar_title[i],
							toolbar_tooltip[i],
							NULL, pixmapwid,
							toolbar_function0,
							(gpointer) NULL);
			break;
		case 1:
			item = gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),
							toolbar_title[i],
							toolbar_tooltip[i],
							NULL, pixmapwid,
							toolbar_function1,
							(gpointer) NULL);
			break;

		case 2:
			item = gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),
							toolbar_title[i],
							toolbar_tooltip[i],
							NULL, pixmapwid,
							toolbar_function2,
							(gpointer) NULL);
			break;

		case 3:
			item = gtk_toolbar_append_item (GTK_TOOLBAR (toolbar),
							toolbar_title[i],
							toolbar_tooltip[i],
							NULL, pixmapwid,
							toolbar_function3,
							(gpointer) NULL);
			break;
		}
	}
}
