/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

CxpPnl *cxppnl;

/*
 * Cxppanel Version Header
 *
 * version  date        log
 *  1.0.0   1999/09/07  first released.
 *  1.0.1   1999/09/14  filename local -> /usr/local/cxplorer chg.
 *  1.0.2   1999/11/11  shape delete. size root_window -> 640 .
 *                      position 0,0.
 *  1.0.3   1999/12/21  config file read bad access.
 *  1.0.4   2000/01/28  menu config file open error bug fix.
 *  1.0.5   2000/04/17  exit code is ZERO add.
 *  1.0.6   2000/08/01  cxpmanager start add.
 *
 */

void cxppnl_init ()
{
	GtkWidget *hpaned;
	GtkWidget *vbox;
	GtkWidget *subitem;
	GtkWidget *separator;
	GtkStyle *style;
	GdkPixmap *pixmap;
	GdkBitmap *basemask;
	GdkWMDecoration deco;
	int row;
	int width, height;

	/* ưɣĤμ */
	cxppnl->uid = getuid ();
	cxppnl->gid = getgid ();

	/* ѥͥμ */
	getPanelConfig (&(cxppnl->panel_kensu), &(cxppnl->panel));

	/* ѥͥ˥塼μ */
	getPanelMenuConfig (&(cxppnl->pmenu_kensu), &(cxppnl->pmenu));


	/* ߤΣؤɽ򻻽Ф */
	cxppnl->xpos = 0;
#if 0
	cxppnl->xpos = 0;
	cxppnl->ypos = gdk_root_parent.height - 60;
	cxppnl->maxwidth = gdk_root_parent.width - 2;
#else
	cxppnl->xpos = 0;
	cxppnl->ypos = 0;
	cxppnl->maxwidth = 640;
#endif
	cxppnl->maxheight = 34;
	cxppnl->minwidth = 16;
	cxppnl->minheight = 34;

	/* ١Υɥ */
	cxppnl->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect (GTK_OBJECT (cxppnl->window), "destroy",
			    GTK_SIGNAL_FUNC (gtk_main_quit), NULL);
	gtk_window_set_title (GTK_WINDOW (cxppnl->window), "Cxppnl");
	gtk_widget_set_usize (cxppnl->window, cxppnl->minwidth,
			      cxppnl->minheight);
	gtk_window_set_default_size (GTK_WINDOW (cxppnl->window),
				     cxppnl->maxwidth, cxppnl->maxheight);
	gtk_window_set_position (GTK_WINDOW (cxppnl->window),
				 GTK_WIN_POS_MOUSE);

	gtk_widget_set_uposition (cxppnl->window, cxppnl->xpos, cxppnl->ypos);

#if 0				/* νϻѤʤ */
	/* ޥ򤫤 */
	style = gtk_widget_get_style (cxppnl->window);

	pixmap = gdk_pixmap_create_from_xpm_d (cxppnl->window->window,
					       &basemask,
					       &style->bg[GTK_STATE_NORMAL],
					       (gchar **)
					       GetMaskData
					       ("/usr/local/cxplorer/panel/xpm/basewin.xpm",
						cxppnl->maxwidth));

	gtk_widget_shape_combine_mask (cxppnl->window, basemask, 0, 0);
#endif

	/* VBOX */
	cxppnl->vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (cxppnl->window), cxppnl->vbox);
	gtk_widget_show (cxppnl->vbox);

	/* HBOX */
	cxppnl->hbox = gtk_hbox_new (FALSE, 0);
#if 0
	gtk_container_add (GTK_CONTAINER (cxppnl->vbox), cxppnl->hbox);
#else

/*******
  separator = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (cxppnl->vbox), separator, FALSE, TRUE, 0);
  gtk_widget_show(separator);
**********/
	gtk_box_pack_start (GTK_BOX (cxppnl->vbox), cxppnl->hbox, FALSE, TRUE,
			    0);
/***********
  separator = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (cxppnl->vbox), separator, FALSE, TRUE, 0);
  gtk_widget_show(separator);
***********/
#endif
	gtk_widget_show (cxppnl->hbox);


	/* ޥɤ */
	cxppnl_cmdinit ();

	/* ɥɽ */
	gtk_widget_show (cxppnl->window);

	return;
}

int main (int argc, char *argv[])
{
	int i;

	CxpBasePathInit ();

	/* ޥ͡㵯ư */
	cxp_manager_start ();

	cxppnl = (CxpPnl *) g_malloc (sizeof (CxpPnl));

	gtk_set_locale ();
	gtk_init (&argc, &argv);

	cxppnl_init ();

	gtk_main ();
	exit (0);
}
