/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

extern CxpPnl *cxppnl;

static int pnlViewStatus;

static void cxppnl_menufunc (GtkWidget * w, gpointer data)
{
	char command[1024];

	if (strcmp (cxppnl->pmenu[(int) data].command, "CXPLOGOUT") == 0)
	{
		exit (0);
	}
	else
	{
		sprintf (command, "%s &", cxppnl->pmenu[(int) data].command);
		system (command);
	}
}

static void pnlHideCallback (GtkWidget * widget, gpointer data)
{
	if (pnlViewStatus == 0)
	{
		gdk_window_get_position (cxppnl->window->window,
					 &cxppnl->xpos, &cxppnl->ypos);

		gtk_widget_hide (cxppnl->window);
		gtk_window_set_default_size (GTK_WINDOW (cxppnl->window),
					     cxppnl->minwidth,
					     cxppnl->minheight);
		gtk_widget_show (cxppnl->window);
		gtk_widget_set_uposition (cxppnl->window,
					  cxppnl->xpos, cxppnl->ypos);

		pnlViewStatus = 1;
	}
	else
	{
		gtk_widget_hide (cxppnl->window);
		gtk_window_set_default_size (GTK_WINDOW (cxppnl->window),
					     cxppnl->maxwidth,
					     cxppnl->maxheight);
		gtk_widget_show (cxppnl->window);
		gtk_widget_set_uposition (cxppnl->window,
					  cxppnl->xpos, cxppnl->ypos);

		pnlViewStatus = 0;
	}
}

static void toolbar_function (GtkWidget * widget, gchar * string)
{
	int i;
	char commands[1024];

	for (i = 0; i < cxppnl->panel_kensu; i++)
	{
		if (strcmp (string, cxppnl->panel[i].command) == 0)
		{
			if (strcmp (cxppnl->panel[i].command, "CXPHOME") == 0)
			{
				sprintf (commands, "cxplorer -dir %s &",
					 (char *) getenv ("HOME"));
				system (commands);
				break;
			}
			else if (strcmp (cxppnl->panel[i].command, "CXPMENU")
				 == 0)
			{
				break;
			}
			else
			{
				sprintf (commands, "%s &",
					 cxppnl->panel[i].command);
				system (commands);
				break;
			}
		}
	}
}

void cxppnl_cmdinit ()
{
	GtkWidget *handle_box;
	GtkWidget *vbox;
	GtkWidget *pixmapwid;
	GtkWidget *item;
	GtkWidget *separator;
	GtkWidget *button;
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	GtkStyle *style;
	int i;

	pnlViewStatus = 0;

	for (i = 0; i < cxppnl->panel_kensu; i++)
	{
		if (strcmp (cxppnl->panel[i].command, "CXPHIDELEFT") == 0)
		{
			pixmap = gdk_pixmap_create_from_xpm (cxppnl->window->
							     window, &mask,
							     &style->
							     bg
							     [GTK_STATE_NORMAL],
							     cxppnl->panel[i].
							     xpm);
			pixmapwid = gtk_pixmap_new (pixmap, mask);

			button = gtk_button_new ();
			gtk_signal_connect (GTK_OBJECT (button), "clicked",
					    GTK_SIGNAL_FUNC (pnlHideCallback),
					    (gpointer) "cool button");
			gtk_container_add (GTK_CONTAINER (button), pixmapwid);

			gtk_box_pack_start (GTK_BOX (cxppnl->hbox), button,
					    FALSE, FALSE, 0);
			gtk_widget_show (pixmapwid);
			gtk_widget_show (button);
		}

		if (strcmp (cxppnl->panel[i].command, "CXPHIDERIGHT") == 0)
		{
			pixmap = gdk_pixmap_create_from_xpm (cxppnl->window->
							     window, &mask,
							     &style->
							     bg
							     [GTK_STATE_NORMAL],
							     cxppnl->panel[i].
							     xpm);
			pixmapwid = gtk_pixmap_new (pixmap, mask);

			button = gtk_button_new ();
			gtk_signal_connect (GTK_OBJECT (button), "clicked",
					    GTK_SIGNAL_FUNC (pnlHideCallback),
					    (gpointer) "cool button");
			gtk_container_add (GTK_CONTAINER (button), pixmapwid);

			gtk_box_pack_end (GTK_BOX (cxppnl->hbox), button,
					  FALSE, FALSE, 0);
			gtk_widget_show (pixmapwid);
			gtk_widget_show (button);
		}
	}


	cxppnl->toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL,
					   GTK_TOOLBAR_BOTH);
	gtk_box_pack_start (GTK_BOX (cxppnl->hbox), cxppnl->toolbar, FALSE,
			    TRUE, 2);

	gtk_toolbar_set_button_relief (GTK_TOOLBAR (cxppnl->toolbar),
				       GTK_RELIEF_NONE);
	gtk_widget_show (cxppnl->toolbar);

	style = gtk_widget_get_style (cxppnl->window);
	for (i = 0; i < cxppnl->panel_kensu; i++)
	{
		if (strcmp (cxppnl->panel[i].command, "CXPHIDELEFT") == 0
		    || strcmp (cxppnl->panel[i].command, "CXPHIDERIGHT") == 0)
			continue;

		pixmap = gdk_pixmap_create_from_xpm (cxppnl->window->window,
						     &mask,
						     &style->
						     bg[GTK_STATE_NORMAL],
						     cxppnl->panel[i].xpm);
		pixmapwid = gtk_pixmap_new (pixmap, mask);

		if (strcmp (cxppnl->panel[i].command, "CXPMENU") == 0)
		{
			GtkWidget *lmenu;
			GtkWidget *lmenuitem;
			GtkWidget *hbox;
			GtkWidget *button;
			GtkItemFactory *item_factory;
			GtkAccelGroup *accel_group;
			GtkItemFactoryEntry menu_items[MAX_PMENU_NUM];
			int nmenu_items;
			int k;

			nmenu_items = cxppnl->pmenu_kensu;

			for (k = 0; k < nmenu_items; k++)
			{
				menu_items[k].path =
					g_strdup (cxppnl->pmenu[k].menuname);
				menu_items[k].accelerator = NULL;
				if (!strcmp
				    (cxppnl->pmenu[k].command, "<Branch>")
				    || !strcmp (cxppnl->pmenu[k].command,
						"<Separator>"))
				{
					menu_items[k].callback = NULL;
					menu_items[k].callback_action = k;
					menu_items[k].item_type =
						g_strdup (cxppnl->pmenu[k].
							  command);
				}
				else
				{
					menu_items[k].callback =
						cxppnl_menufunc;
					menu_items[k].callback_action = k;
					menu_items[k].item_type = NULL;
				}
			}

			accel_group = gtk_accel_group_new ();

			item_factory =
				gtk_item_factory_new (GTK_TYPE_MENU_BAR,
						      "<main>", accel_group);

			gtk_item_factory_create_items (item_factory,
						       nmenu_items,
						       menu_items, NULL);

			gtk_accel_group_attach (accel_group,
						GTK_OBJECT (cxppnl->window));

			cxppnl->menubar =
				gtk_item_factory_get_widget (item_factory,
							     "<main>");

			gtk_menu_bar_set_shadow_type (GTK_MENU_BAR
						      (cxppnl->menubar),
						      GTK_ARG_READWRITE);

			gtk_widget_show (cxppnl->menubar);

			item = gtk_toolbar_append_item (GTK_TOOLBAR
							(cxppnl->toolbar),
							NULL,
							cxppnl->panel[i].hint,
							NULL, cxppnl->menubar,
							toolbar_function,
							(gpointer)
							g_strdup (cxppnl->
								  panel[i].
								  command));

		}
		else
		{
			item = gtk_toolbar_append_item (GTK_TOOLBAR
							(cxppnl->toolbar),
							NULL,
							cxppnl->panel[i].hint,
							NULL, pixmapwid,
							toolbar_function,
							(gpointer)
							g_strdup (cxppnl->
								  panel[i].
								  command));
		}
	}
}
