/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

char *GetMaskData (filename, width)
     char *filename;
     int width;
{
	static char *buff[2048];
	static char *readbuff[2048];
	static int count = 0;
	FILE *fp;
	int w, h, c, t, i, k;
	int ww;
	int size;
	char work[256];
	char rbuff[2048];
	char *ptr;

	if ((fp = fopen (filename, "r")) == NULL)
	{
		fprintf (stderr, "Open Error [%s]\n", filename);
		return ((char *) error_xpm);
	}

	k = 0;
	while (fgets (rbuff, sizeof (rbuff), fp) != 0)
	{
		if (strmatch ("/*/*", rbuff) == 0)
			continue;
		if (strmatch ("\"*\"*", rbuff) == 0)
		{
			ptr = strrchr (rbuff, '"');
			*ptr = 0x00;
			ptr = strchr (rbuff, '"');

			readbuff[k] = (char *) malloc (strlen (ptr + 1) + 1);
			strcpy (readbuff[k], ptr + 1);
			k++;
		}
	}

	fclose (fp);

	sscanf (readbuff[0], "%d %d %d %d", &w, &h, &c, &t);
	ww = w * width;
	sprintf (work, "%d %d %d %d", ww, h, c, t);
	buff[0] = (char *) malloc (strlen (work) + 1);
	strcpy (buff[0], work);
	for (i = 0; i < c; i++)
	{
		buff[i + 1] = (char *) malloc (strlen (readbuff[i + 1]) + 1);
		strcpy (buff[i + 1], readbuff[i + 1]);
	}

	for (k = i; k < (h + i); k++)
	{
		buff[k + 1] = (char *) malloc (ww + 1);
		sprintf (buff[k + 1], "%*.*s", (ww), (ww), " ");
	}

	for (k = 0; k < (h + i) + 1; k++)
	{
		free (readbuff[k]);
	}


	return ((char *) buff);
}
