/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxprestore.h"

extern CxpRestore *cxprestore;

extern int showListEventFunc ();
extern int showListSelectionFunc ();
extern int showListUnSelectionFunc ();
extern int showListSelectBtnFunc ();
extern int showListUnSelectBtnFunc ();
extern int showListAllClearBtnFunc ();
extern int showListAllSelectBtnFunc ();
extern int cxprestorehelpfunc_help ();
extern int startBtnFunc ();
extern int showBtnFunc ();
extern void compressRadioFunc ();
extern void deviceRadioFunc ();

static void filemenu_response ();
static void helpmenu_response ();

#define FILEIACT_CLOSE          0x0101
#define HELPIACT_HELP           0x0901

#define FILEMENU_BASE           "/ե"
#define FILEMENU_CLOSE          "/ե/λ"
#define HELPMENU_BASE           "/إ"
#define HELPMENU_HELP           "/إ/CxprestoreˤĤ"

static GtkItemFactoryEntry menu_items[] = {
	{FILEMENU_BASE, NULL, NULL, 0, "<Branch>"},
	{FILEMENU_CLOSE, "<control>Q", filemenu_response, FILEIACT_CLOSE,
	 NULL},
	{HELPMENU_BASE, NULL, NULL, 0, "<LastBranch>"},
	{HELPMENU_HELP, NULL, helpmenu_response, HELPIACT_HELP, NULL},
};

static char *restoretitle[1] = { "ǥ쥯ȥ"
};

static int cxprestorefunc_close ()
{
	gtk_main_quit ();
}

static void filemenu_response (GtkWidget * w, gpointer data)
{
	switch ((int) data)
	{
	case FILEIACT_CLOSE:
		cxprestorefunc_close ();
		break;
	}
}

static void helpmenu_response (GtkWidget * w, gpointer data)
{
	switch ((int) data)
	{
	case HELPIACT_HELP:
		cxprestorehelpfunc_help ();
		break;
	}
}

cxprestore_start ()
{
	GtkWidget *vbox1;
	GtkWidget *hbox1;
	GtkWidget *vbox2;
	GtkWidget *hbox2;
	GtkWidget *hbox3;
	GtkWidget *hbox4;
	GtkWidget *vbox3;
	GtkWidget *label1;
	GtkWidget *hbox6;
	GtkWidget *label2;
	GtkWidget *hbox7;
	GtkWidget *label3;
	GSList *hbox7_group = NULL;
	GtkWidget *hbox8;
	GtkWidget *label4;
	GSList *hbox8_group = NULL;
	GtkWidget *hbox9;
	GtkWidget *label5;
	GtkWidget *compressMenu_menu;
	GtkWidget *deviceMenu_menu;
	GtkWidget *label6;
	GtkWidget *hbox10;
	GtkWidget *label7;
	GtkWidget *hbox11;
	GtkWidget *label8;
	GtkWidget *hbox12;
	GtkWidget *label9;
	GtkWidget *label10;
	GtkWidget *hbox13;
	GtkWidget *swin;
	GtkWidget *glade_menuitem;
	GtkItemFactory *item_factory;
	GtkAccelGroup *accel_group;
	GSList *compressGroup;
	GSList *deviceGroup;
	int nmenu_items = sizeof (menu_items) / sizeof (menu_items[0]);
	int i;
	char currentBuff[MAX_DIR_LENGTH];


	cxprestore->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_object_set_data (GTK_OBJECT (cxprestore->window), "window",
			     cxprestore->window);
	gtk_widget_set_usize (cxprestore->window, 100, 100);
	gtk_window_set_title (GTK_WINDOW (cxprestore->window), "Cxprestore");
	gtk_window_set_default_size (GTK_WINDOW (cxprestore->window), 600,
				     400);
	gtk_signal_connect (GTK_OBJECT (cxprestore->window), "destroy",
			    GTK_SIGNAL_FUNC (cxprestorefunc_close), NULL);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->window), "vbox1",
				  vbox1, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);
	gtk_container_add (GTK_CONTAINER (cxprestore->window), vbox1);

	accel_group = gtk_accel_group_new ();

	item_factory =
		gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>",
				      accel_group);

	gtk_item_factory_create_items (item_factory, nmenu_items, menu_items,
				       NULL);

	gtk_accel_group_attach (accel_group, GTK_OBJECT (cxprestore->window));

	cxprestore->menubar =
		gtk_item_factory_get_widget (item_factory, "<main>");
	gtk_box_pack_start (GTK_BOX (vbox1), cxprestore->menubar, FALSE,
			    FALSE, 0);
	gtk_widget_show (cxprestore->menubar);


	hbox1 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox1);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->window), "hbox1",
				  hbox1, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox1);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox1, TRUE, TRUE, 0);

	vbox2 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox2);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->window), "vbox2",
				  vbox2, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox2);
	gtk_box_pack_start (GTK_BOX (hbox1), vbox2, TRUE, TRUE, 0);

	hbox2 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox2);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->window), "hbox2",
				  hbox2, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox2);
	gtk_box_pack_start (GTK_BOX (vbox2), hbox2, FALSE, TRUE, 5);

	cxprestore->showBtn = gtk_button_new_with_label (" ǡƳǧ ");
	gtk_widget_ref (cxprestore->showBtn);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->window), "showBtn",
				  cxprestore->showBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxprestore->showBtn);
	gtk_box_pack_start (GTK_BOX (hbox2), cxprestore->showBtn, FALSE,
			    FALSE, 0);

	hbox3 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox3);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->window), "hbox3",
				  hbox3, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox3);
	gtk_box_pack_start (GTK_BOX (vbox2), hbox3, TRUE, TRUE, 0);

#if 0
	showList = gtk_list_new ();
	gtk_widget_ref (showList);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->window), "showList",
				  showList,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (showList);
	gtk_box_pack_start (GTK_BOX (hbox3), showList, TRUE, TRUE, 5);
	gtk_widget_set_usize (showList, 200, -2);
	gtk_list_set_selection_mode (GTK_LIST (showList),
				     GTK_SELECTION_BROWSE);
#else
	swin = gtk_scrolled_window_new (NULL, NULL);

	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (swin),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_AUTOMATIC);
	gtk_widget_show (swin);

	cxprestore->showList = gtk_clist_new_with_titles (1, restoretitle);
	gtk_widget_set_usize (cxprestore->showList, 200, 150);
	gtk_clist_set_selection_mode (GTK_CLIST (cxprestore->showList),
				      GTK_SELECTION_BROWSE);
	gtk_widget_set_usize (cxprestore->showList, 330, -2);

	/* ꥹȥХå */
	gtk_signal_connect (GTK_OBJECT (cxprestore->showList), "event",
			    GTK_SIGNAL_FUNC (showListEventFunc), NULL);
	gtk_signal_connect (GTK_OBJECT (cxprestore->showList), "select_row",
			    GTK_SIGNAL_FUNC (showListSelectionFunc), NULL);
	gtk_signal_connect (GTK_OBJECT (cxprestore->showList), "unselect_row",
			    GTK_SIGNAL_FUNC (showListUnSelectionFunc), NULL);

	gtk_clist_column_title_passive (GTK_CLIST (cxprestore->showList), 0);

	gtk_container_add (GTK_CONTAINER (swin), cxprestore->showList);
	gtk_widget_show (cxprestore->showList);

	gtk_box_pack_start (GTK_BOX (hbox3), swin, TRUE, TRUE, 5);
#endif

	hbox4 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox4);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->window), "hbox4",
				  hbox4, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox4);
	gtk_box_pack_start (GTK_BOX (vbox2), hbox4, FALSE, TRUE, 5);

	cxprestore->selectBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (cxprestore->selectBtn);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->window),
				  "selectBtn", cxprestore->selectBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxprestore->selectBtn);
	gtk_box_pack_start (GTK_BOX (hbox4), cxprestore->selectBtn, FALSE,
			    FALSE, 0);

	cxprestore->clearBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (cxprestore->clearBtn);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->window), "clearBtn",
				  cxprestore->clearBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxprestore->clearBtn);
	gtk_box_pack_start (GTK_BOX (hbox4), cxprestore->clearBtn, FALSE,
			    FALSE, 0);

	cxprestore->allSelectBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (cxprestore->allSelectBtn);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->window),
				  "allSelectBtn", cxprestore->allSelectBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxprestore->allSelectBtn);
	gtk_box_pack_start (GTK_BOX (hbox4), cxprestore->allSelectBtn, FALSE,
			    FALSE, 0);

	cxprestore->allClearBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (cxprestore->allClearBtn);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->window),
				  "allClearBtn", cxprestore->allClearBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxprestore->allClearBtn);
	gtk_box_pack_start (GTK_BOX (hbox4), cxprestore->allClearBtn, FALSE,
			    FALSE, 0);

	vbox3 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox3);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->window), "vbox3",
				  vbox3, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox3);
	gtk_box_pack_start (GTK_BOX (hbox1), vbox3, FALSE, TRUE, 0);

	label1 = gtk_label_new ("     ");
	gtk_widget_ref (label1);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->window), "label1",
				  label1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label1);
	gtk_box_pack_start (GTK_BOX (vbox3), label1, TRUE, FALSE, 0);

	hbox6 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox6);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->window), "hbox6",
				  hbox6, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox6);
	gtk_box_pack_start (GTK_BOX (vbox3), hbox6, FALSE, TRUE, 0);

	label2 = gtk_label_new ("  ץ");
	gtk_widget_ref (label2);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->window), "label2",
				  label2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label2);
	gtk_box_pack_start (GTK_BOX (hbox6), label2, FALSE, FALSE, 0);

	hbox7 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox7);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->window), "hbox7",
				  hbox7, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox7);
	gtk_box_pack_start (GTK_BOX (vbox3), hbox7, FALSE, TRUE, 0);

	label3 = gtk_label_new ("ǡ");
	gtk_widget_ref (label3);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->window), "label3",
				  label3,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label3);
	gtk_box_pack_start (GTK_BOX (hbox7), label3, FALSE, FALSE, 0);

	cxprestore->compressRadioBtn1 =
		gtk_radio_button_new_with_label (hbox7_group, "Ʋࡡ");
	hbox7_group =
		gtk_radio_button_group (GTK_RADIO_BUTTON
					(cxprestore->compressRadioBtn1));
	gtk_widget_ref (cxprestore->compressRadioBtn1);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->window),
				  "compressRadioBtn1",
				  cxprestore->compressRadioBtn1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxprestore->compressRadioBtn1);
	gtk_box_pack_start (GTK_BOX (hbox7), cxprestore->compressRadioBtn1,
			    FALSE, FALSE, 0);

	cxprestore->compressRadioBtn2 =
		gtk_radio_button_new_with_label (hbox7_group, "Τ߲");
	hbox7_group =
		gtk_radio_button_group (GTK_RADIO_BUTTON
					(cxprestore->compressRadioBtn2));
	gtk_widget_ref (cxprestore->compressRadioBtn2);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->window),
				  "compressRadioBtn2",
				  cxprestore->compressRadioBtn2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxprestore->compressRadioBtn2);
	gtk_box_pack_start (GTK_BOX (hbox7), cxprestore->compressRadioBtn2,
			    FALSE, FALSE, 0);

	hbox8 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox8);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->window), "hbox8",
				  hbox8, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox8);
	gtk_box_pack_start (GTK_BOX (vbox3), hbox8, FALSE, TRUE, 0);

	label4 = gtk_label_new ("ǡ");
	gtk_widget_ref (label4);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->window), "label4",
				  label4,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label4);
	gtk_box_pack_start (GTK_BOX (hbox8), label4, FALSE, FALSE, 0);

	cxprestore->dataRadioBtn1 =
		gtk_radio_button_new_with_label (hbox8_group, "Ƥ");
	hbox8_group =
		gtk_radio_button_group (GTK_RADIO_BUTTON
					(cxprestore->dataRadioBtn1));
	gtk_widget_ref (cxprestore->dataRadioBtn1);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->window),
				  "dataRadioBtn1", cxprestore->dataRadioBtn1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxprestore->dataRadioBtn1);
	gtk_box_pack_start (GTK_BOX (hbox8), cxprestore->dataRadioBtn1, FALSE,
			    FALSE, 0);

	cxprestore->dataRadioBtn2 =
		gtk_radio_button_new_with_label (hbox8_group, "Ƥʤ");
	hbox8_group =
		gtk_radio_button_group (GTK_RADIO_BUTTON
					(cxprestore->dataRadioBtn2));
	gtk_widget_ref (cxprestore->dataRadioBtn2);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->window),
				  "dataRadioBtn2", cxprestore->dataRadioBtn2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxprestore->dataRadioBtn2);
	gtk_box_pack_start (GTK_BOX (hbox8), cxprestore->dataRadioBtn2, FALSE,
			    FALSE, 0);

	hbox9 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox9);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->window), "hbox9",
				  hbox9, (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox9);
	gtk_box_pack_start (GTK_BOX (vbox3), hbox9, FALSE, TRUE, 0);

	label5 = gtk_label_new ("     ");
	gtk_widget_ref (label5);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->window), "label5",
				  label5,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label5);
	gtk_box_pack_start (GTK_BOX (hbox9), label5, FALSE, FALSE, 0);

#if 0
	optionmenu1 = gtk_option_menu_new ();
	gtk_widget_ref (optionmenu1);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->window),
				  "optionmenu1", optionmenu1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (optionmenu1);
	gtk_box_pack_start (GTK_BOX (hbox9), optionmenu1, FALSE, FALSE, 0);
	optionmenu1_menu = gtk_menu_new ();
	gtk_option_menu_set_menu (GTK_OPTION_MENU (optionmenu1),
				  optionmenu1_menu);
#else
	cxprestore->compressMenu = gtk_option_menu_new ();
	compressMenu_menu = gtk_menu_new ();

	compressGroup = NULL;
	/* gzip menu */
	glade_menuitem =
		gtk_radio_menu_item_new_with_label (compressGroup, "gzip");
	gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate",
			    (GtkSignalFunc) compressRadioFunc,
			    (gpointer) NULL);
	compressGroup =
		gtk_radio_menu_item_group (GTK_RADIO_MENU_ITEM
					   (glade_menuitem));
	gtk_menu_append (GTK_MENU (compressMenu_menu), glade_menuitem);
	gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (glade_menuitem),
					TRUE);
	gtk_widget_show (glade_menuitem);

	/* compress menu */
	glade_menuitem =
		gtk_radio_menu_item_new_with_label (compressGroup,
						    "compress");
	gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate",
			    (GtkSignalFunc) compressRadioFunc,
			    (gpointer) NULL);
	compressGroup =
		gtk_radio_menu_item_group (GTK_RADIO_MENU_ITEM
					   (glade_menuitem));
	gtk_menu_append (GTK_MENU (compressMenu_menu), glade_menuitem);
	gtk_widget_show (glade_menuitem);

	gtk_option_menu_set_menu (GTK_OPTION_MENU (cxprestore->compressMenu),
				  compressMenu_menu);
	gtk_widget_show (compressMenu_menu);
	gtk_widget_show (cxprestore->compressMenu);
	gtk_box_pack_start (GTK_BOX (hbox9), cxprestore->compressMenu, FALSE,
			    FALSE, 0);

#endif

	label6 = gtk_label_new ("     ");
	gtk_widget_ref (label6);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->window), "label6",
				  label6,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label6);
	gtk_box_pack_start (GTK_BOX (vbox3), label6, TRUE, FALSE, 0);

	hbox10 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox10);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->window), "hbox10",
				  hbox10,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox10);
	gtk_box_pack_start (GTK_BOX (vbox3), hbox10, FALSE, FALSE, 0);

	label7 = gtk_label_new ("  ");
	gtk_widget_ref (label7);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->window), "label7",
				  label7,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label7);
	gtk_box_pack_start (GTK_BOX (hbox10), label7, FALSE, FALSE, 0);

	hbox11 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox11);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->window), "hbox11",
				  hbox11,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox11);
	gtk_box_pack_start (GTK_BOX (vbox3), hbox11, FALSE, TRUE, 0);

	cxprestore->restoreEntry = gtk_entry_new ();
	gtk_widget_ref (cxprestore->restoreEntry);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->window),
				  "restoreEntry", cxprestore->restoreEntry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxprestore->restoreEntry);
	gtk_box_pack_start (GTK_BOX (hbox11), cxprestore->restoreEntry, TRUE,
			    TRUE, 20);

	label8 = gtk_label_new ("     ");
	gtk_widget_ref (label8);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->window), "label8",
				  label8,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label8);
	gtk_box_pack_start (GTK_BOX (vbox3), label8, TRUE, FALSE, 0);

	hbox12 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox12);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->window), "hbox12",
				  hbox12,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox12);
	gtk_box_pack_start (GTK_BOX (vbox3), hbox12, FALSE, TRUE, 0);

	label9 = gtk_label_new ("       ");
	gtk_widget_ref (label9);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->window), "label9",
				  label9,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label9);
	gtk_box_pack_start (GTK_BOX (hbox12), label9, FALSE, FALSE, 0);

#if 0
	optionmenu2 = gtk_option_menu_new ();
	gtk_widget_ref (optionmenu2);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->window),
				  "optionmenu2", optionmenu2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (optionmenu2);
	gtk_box_pack_start (GTK_BOX (hbox12), optionmenu2, FALSE, FALSE, 0);
	optionmenu2_menu = gtk_menu_new ();
	gtk_option_menu_set_menu (GTK_OPTION_MENU (optionmenu2),
				  optionmenu2_menu);
#else
	cxprestore->deviceMenu = gtk_option_menu_new ();
	deviceMenu_menu = gtk_menu_new ();

	deviceGroup = NULL;
	for (i = 0; i < cxprestore->devinf.device_kensu; i++)
	{
		if (cxprestore->devinf.device[i].backupFlag != 0)
			continue;
		glade_menuitem =
			gtk_radio_menu_item_new_with_label (deviceGroup,
							    cxprestore->
							    devinf.device[i].
							    name);
		gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate",
				    (GtkSignalFunc) deviceRadioFunc,
				    (gpointer) NULL);
		deviceGroup =
			gtk_radio_menu_item_group (GTK_RADIO_MENU_ITEM
						   (glade_menuitem));
		gtk_menu_append (GTK_MENU (deviceMenu_menu), glade_menuitem);
		if (i == 0)
			gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
							(glade_menuitem),
							TRUE);
		gtk_widget_show (glade_menuitem);
	}

	gtk_option_menu_set_menu (GTK_OPTION_MENU (cxprestore->deviceMenu),
				  deviceMenu_menu);
	gtk_widget_show (deviceMenu_menu);
	gtk_widget_show (cxprestore->deviceMenu);
	gtk_box_pack_start (GTK_BOX (hbox12), cxprestore->deviceMenu, FALSE,
			    FALSE, 0);

#endif

	label10 = gtk_label_new ("     ");
	gtk_widget_ref (label10);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->window), "label10",
				  label10,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label10);
	gtk_box_pack_start (GTK_BOX (vbox3), label10, TRUE, FALSE, 0);

	hbox13 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox13);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->window), "hbox13",
				  hbox13,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox13);
	gtk_box_pack_start (GTK_BOX (vbox3), hbox13, FALSE, TRUE, 5);

	cxprestore->startBtn = gtk_button_new_with_label (" ꥹȥ ");
	gtk_widget_ref (cxprestore->startBtn);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->window), "startBtn",
				  cxprestore->startBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cxprestore->startBtn);
	gtk_box_pack_start (GTK_BOX (hbox13), cxprestore->startBtn, FALSE,
			    FALSE, 0);


	/* ꥹȥܥ󥳡Хå */
	gtk_signal_connect_object (GTK_OBJECT (cxprestore->selectBtn),
				   "clicked",
				   (GtkSignalFunc) showListSelectBtnFunc, 0);
	gtk_signal_connect_object (GTK_OBJECT (cxprestore->clearBtn),
				   "clicked",
				   (GtkSignalFunc) showListUnSelectBtnFunc,
				   0);
	gtk_signal_connect_object (GTK_OBJECT (cxprestore->allSelectBtn),
				   "clicked",
				   (GtkSignalFunc) showListAllSelectBtnFunc,
				   0);
	gtk_signal_connect_object (GTK_OBJECT (cxprestore->allClearBtn),
				   "clicked",
				   (GtkSignalFunc) showListAllClearBtnFunc,
				   0);

	/* ֳ/λܥ󥳡Хå */
	gtk_signal_connect_object (GTK_OBJECT (cxprestore->startBtn),
				   "clicked", (GtkSignalFunc) startBtnFunc,
				   0);

	/* ǡƳǧܥ󥳡Хå */
	gtk_signal_connect_object (GTK_OBJECT (cxprestore->showBtn),
				   "clicked", (GtkSignalFunc) showBtnFunc, 0);


	if (!getcwd (currentBuff, MAX_DIR_LENGTH))
		strcpy (currentBuff, "/tmp");

	gtk_entry_set_text (GTK_ENTRY (cxprestore->restoreEntry),
			    currentBuff);

	gtk_widget_show (cxprestore->window);
}
