/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxprestore.h"

extern CxpRestore *cxprestore;

printRestoreDirectory (dinfo, next, totalcount)
     BDINFO *dinfo;
     int next;
     int *totalcount;
{
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	GtkStyle *style;
	char *pixname;
	char buffname[512];
	char *dirname[2];
	char *ptr;
	int i, k;
	int nx = next + 1;

	for (i = 0; i < dinfo->count; i++)
	{
#ifdef	DEBUG8
		fprintf (stdout, "buffname [%s]\n", dinfo->bfinfo[i]->fname);
#endif

		strcpy (buffname, dinfo->bfinfo[i]->fname);
		dirname[0] = g_strdup (buffname);
		gtk_clist_append (GTK_CLIST (cxprestore->showList), dirname);

		style = gtk_widget_get_style (cxprestore->window);
		if (dinfo->bfinfo[i]->select == DIR_VIEW_SELECT)
			pixname = cxprestore->base.selecton;
		else if (dinfo->bfinfo[i]->select == DIR_VIEW_SUBSELECT)
			pixname = cxprestore->base.selectsub;
		else
			pixname = cxprestore->base.selectoff;

		pixmap = gdk_pixmap_create_from_xpm_d (cxprestore->window->
						       window, &mask,
						       &style->
						       bg[GTK_STATE_NORMAL],
						       (gchar **)
						       MakeXPMdataByRestore
						       (pixname, nx));

		gtk_clist_set_pixtext (GTK_CLIST (cxprestore->showList), (*totalcount),	/* row    */
				       0,	/* collum */
				       buffname,	/* text   */
				       2,	/* spacing size */
				       pixmap,	/* pixmap */
				       mask);	/* mask */

		dinfo->bfinfo[i]->row = (*totalcount);
		(*totalcount)++;

	}
}

BFINFO *getDirectoryInfoRow (dinfo, row)
     BDINFO *dinfo;
     int row;
{
	int i, k;

	for (i = 0; i < dinfo->count; i++)
	{
		if (dinfo->bfinfo[i]->row == row)
			return ((BFINFO *) dinfo->bfinfo[i]);
	}
	return ((BFINFO *) NULL);
}

makeRestoreListData (dinfo)
     BDINFO *dinfo;
{
	FILE *fp;
	char buff[1024];
	char *ptr;
	int kensu;

	if ((fp = fopen (cxprestore->restoreList, "r")) == (FILE *) NULL)
		return (0);

	kensu = 0;
	while (fgets (buff, sizeof (buff), fp) != 0)
	{
		if ((ptr = strchr (buff, '\n')) != (char *) NULL)
			*ptr = (char) NULL;

		if (dinfo->bfinfo[kensu] == (BFINFO *) NULL)
		{
			dinfo->bfinfo[kensu] =
				(BFINFO *) malloc (sizeof (BFINFO));
			memset (dinfo->bfinfo[kensu], 0x00, sizeof (BFINFO));
		}
		dinfo->bfinfo[kensu]->select = DIR_VIEW_SELECT;
		dinfo->bfinfo[kensu]->fname = g_strdup (buff);
		kensu++;
	}
	dinfo->count = kensu;

	fclose (fp);
}
