/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxprestore.h"

extern CxpRestore *cxprestore;

int showListEventFunc (GtkWidget * widget, GdkEvent * event)
{
	return FALSE;
}

int showListSelectionFunc (clist, row, column, event, data)
     GtkWidget *clist;
     gint row;
     gint column;
     GdkEventButton *event;
     gpointer data;
{
	BFINFO *bfinfo;
	int totalcount;

	if (row < 0)
		return (0);

	if (cxprestore->currentViewFlag == 1)
		return (0);

	cxprestore->selectrow = row;

	return (0);
}

int showListUnSelectionFunc (clist, row, column, event, data)
     GtkWidget *clist;
     gint row;
     gint column;
     GdkEventButton *event;
     gpointer data;
{
	if (cxprestore->currentViewFlag == 1)
		return (0);

	/* 򥯥ꥢ */
	cxprestore->selectrow = -1;

	return (0);
}

int showListSelectBtnFunc (GtkWidget * widget, gpointer data)
{
	BFINFO *bfinfo;
	int totalcount;
	int i;

	if (cxprestore->selectrow < 0)
		return (0);

	bfinfo = (BFINFO *) getDirectoryInfoRow (&cxprestore->root,
						 cxprestore->selectrow);
	if (bfinfo == (BFINFO *) NULL)
		return (0);

	bfinfo->select = DIR_VIEW_SELECT;

	cxprestore->currentViewFlag = 1;

	gtk_clist_freeze (GTK_CLIST (cxprestore->showList));
	gtk_clist_clear (GTK_CLIST (cxprestore->showList));
	totalcount = 0;
	printRestoreDirectory (&cxprestore->root, -1, &totalcount);

	/* ɽ֤򹹿 */
	gtk_clist_select_row (GTK_CLIST (cxprestore->showList),
			      cxprestore->selectrow, 0);

	/* ɽ濴 */
	gtk_clist_moveto (GTK_CLIST (cxprestore->showList),
			  cxprestore->selectrow, 0, (gfloat) 0.5,
			  (gfloat) 0.0);

	gtk_clist_thaw (GTK_CLIST (cxprestore->showList));

	cxprestore->currentViewFlag = 0;

	return (0);
}

int showListUnSelectBtnFunc (GtkWidget * widget, gpointer data)
{
	BFINFO *bfinfo;
	int totalcount;

	if (cxprestore->selectrow < 0)
		return (0);

	bfinfo = (BFINFO *) getDirectoryInfoRow (&cxprestore->root,
						 cxprestore->selectrow);
	if (bfinfo == (BFINFO *) NULL)
		return (0);

	bfinfo->select = DIR_VIEW_UNSELECT;

	cxprestore->currentViewFlag = 1;

	gtk_clist_freeze (GTK_CLIST (cxprestore->showList));
	gtk_clist_clear (GTK_CLIST (cxprestore->showList));
	totalcount = 0;
	printRestoreDirectory (&cxprestore->root, -1, &totalcount);

	/* ɽ֤򹹿 */
	gtk_clist_select_row (GTK_CLIST (cxprestore->showList),
			      cxprestore->selectrow, 0);

	/* ɽ濴 */
	gtk_clist_moveto (GTK_CLIST (cxprestore->showList),
			  cxprestore->selectrow, 0, (gfloat) 0.5,
			  (gfloat) 0.0);

	gtk_clist_thaw (GTK_CLIST (cxprestore->showList));

	cxprestore->currentViewFlag = 0;


	return (0);
}

int showListAllSelectBtnFunc (GtkWidget * widget, gpointer data)
{
	BDINFO *bdinfo;
	int totalcount;
	int i;

	if (cxprestore->selectrow < 0)
		return (0);

	bdinfo = &cxprestore->root;
	if (bdinfo == (BDINFO *) NULL)
		return (0);

	for (i = 0; i < bdinfo->count; i++)
	{
		bdinfo->bfinfo[i]->select = DIR_VIEW_SELECT;
	}

	cxprestore->currentViewFlag = 1;

	gtk_clist_freeze (GTK_CLIST (cxprestore->showList));
	gtk_clist_clear (GTK_CLIST (cxprestore->showList));
	totalcount = 0;
	printRestoreDirectory (&cxprestore->root, -1, &totalcount);

	/* ɽ֤򹹿 */
	gtk_clist_select_row (GTK_CLIST (cxprestore->showList),
			      cxprestore->selectrow, 0);

	/* ɽ濴 */
	gtk_clist_moveto (GTK_CLIST (cxprestore->showList),
			  cxprestore->selectrow, 0, (gfloat) 0.5,
			  (gfloat) 0.0);

	gtk_clist_thaw (GTK_CLIST (cxprestore->showList));

	cxprestore->currentViewFlag = 0;

	return (0);
}


int showListAllClearBtnFunc (GtkWidget * widget, gpointer data)
{
	BDINFO *bdinfo;
	int totalcount;
	int i;

	if (cxprestore->selectrow < 0)
		return (0);

	bdinfo = &cxprestore->root;
	if (bdinfo == (BDINFO *) NULL)
		return (0);

	for (i = 0; i < bdinfo->count; i++)
	{
		bdinfo->bfinfo[i]->select = DIR_VIEW_UNSELECT;
	}

	cxprestore->currentViewFlag = 1;

	gtk_clist_freeze (GTK_CLIST (cxprestore->showList));
	gtk_clist_clear (GTK_CLIST (cxprestore->showList));
	totalcount = 0;
	printRestoreDirectory (&cxprestore->root, -1, &totalcount);

	/* ɽ֤򹹿 */
	gtk_clist_select_row (GTK_CLIST (cxprestore->showList),
			      cxprestore->selectrow, 0);

	/* ɽ濴 */
	gtk_clist_moveto (GTK_CLIST (cxprestore->showList),
			  cxprestore->selectrow, 0, (gfloat) 0.5,
			  (gfloat) 0.0);

	gtk_clist_thaw (GTK_CLIST (cxprestore->showList));

	cxprestore->currentViewFlag = 0;

	return (0);
}

int makeRestoreList (FILE * fp)
{
	BDINFO *bdinfo;
	int totalcount;
	int i;

	totalcount = 0;

	bdinfo = &cxprestore->root;
	for (i = 0; i < bdinfo->count; i++)
	{
		if (bdinfo->bfinfo[i]->select == DIR_VIEW_SELECT)
		{
			if (totalcount != 0)
				fprintf (fp, "\n");
			fprintf (fp, "%s", bdinfo->bfinfo[i]->fname);
			totalcount++;
		}
	}

	return (totalcount);
}

void compressRadioFunc (GtkWidget * widget, gpointer data)
{
	GSList *glist;
	GtkRadioMenuItem *rmi;
	gint i;

	if (!GTK_WIDGET_MAPPED (widget))
		return;

	rmi = (GtkRadioMenuItem
	       *) (((GtkOptionMenu *) cxprestore->compressMenu)->menu_item);
	i = 0;
	glist = gtk_radio_menu_item_group (rmi);
	while (glist && !((GtkCheckMenuItem *) (glist->data))->active)
	{
		glist = glist->next;
		i++;
	}

	cxprestore->compressNo = i;
}

void deviceRadioFunc (GtkWidget * widget, gpointer data)
{
	GSList *glist;
	GtkRadioMenuItem *rmi;
	gint i;

	if (!GTK_WIDGET_MAPPED (widget))
		return;

	rmi = (GtkRadioMenuItem
	       *) (((GtkOptionMenu *) cxprestore->deviceMenu)->menu_item);
	i = 0;
	glist = gtk_radio_menu_item_group (rmi);
	while (glist && !((GtkCheckMenuItem *) (glist->data))->active)
	{
		glist = glist->next;
		i++;
	}

	cxprestore->deviceNo = i;
}
