/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxprestore.h"

extern CxpRestore *cxprestore;

extern int stopHeadFunc ();
extern int cxprestore_headWindowClose ();
static GtkWidget *headBtn;

int showBtnFunc (GtkWidget * widget, gpointer data)
{
	FILE *restoreFp;
	char command[1024];
	char programName[256];
	char programCmd[1024];
	char localName[1024];
	char deviceName[256];
	char *cmdOption[12];
	int status;


	/* ꥹȥץκ() */
	cxprestore->compressFlag = 0;
	if (GTK_TOGGLE_BUTTON (cxprestore->dataRadioBtn1)->active)
	{
		cxprestore->compressFlag = 1;
	}
	if (GTK_TOGGLE_BUTTON (cxprestore->dataRadioBtn2)->active)
	{
		cxprestore->compressFlag = 0;
	}

	compressRadioFunc (cxprestore->compressMenu, (gpointer) NULL);
	deviceRadioFunc (cxprestore->deviceMenu, (gpointer) NULL);

	{
		int _compNo, _devNo, _k, _m;

		_compNo = 1 - cxprestore->compressNo;
		_devNo = (cxprestore->devinf.device_kensu - 1) -
			cxprestore->deviceNo;
		cxprestore->compressNo = _compNo;

		_m = 0;
		for (_k = 0; _k < cxprestore->devinf.device_kensu; _k++)
		{
			if (cxprestore->devinf.device[_k].backupFlag != 0)
				continue;

			if (_devNo == _m)
			{
				_devNo = _k;
				break;
			}
			_m++;

		}

		cxprestore->deviceNo = _devNo;
	}

	/* ̾κ */
	sprintf (localName, "/tmp/.cxprestore.%d_%d.log",
		 cxprestore->uid, cxprestore->pid);
	sprintf (command, "touch %s", localName);
	cxprestore->savePid = -1;
	cxprestore->headPid = -1;
	system (command);
	cxprestore->normalLog = g_strdup (localName);

	/* ٹκ */
	sprintf (localName, "/tmp/.cxprestore.%d_%d.err",
		 cxprestore->uid, cxprestore->pid);
	sprintf (command, "touch %s", localName);
	cxprestore->savePid = -1;
	cxprestore->headPid = -1;
	system (command);
	cxprestore->errorLog = g_strdup (localName);

	/* ꥹȥꥹȤŸ */
	sprintf (localName, "/tmp/.cxprestore_%d_%d_listfile",
		 cxprestore->uid, cxprestore->pid);
	sprintf (command, "mkdir %s", localName);
	cxprestore->savePid = -1;
	cxprestore->headPid = -1;
	system (command);
	cxprestore->backupList = g_strdup (localName);


	/* ǥХ̾μ */
	sprintf (deviceName, "%s",
		 cxprestore->devinf.device[cxprestore->deviceNo].path);

	/* TARޥɺ */
	sprintf (programName, "/bin/tar");

	if (cxprestore->compressFlag == 1)
	{
		sprintf (programCmd, "xf%s",
			 (cxprestore->compressNo == 0 ? "z" :
			  (cxprestore->compressNo == 1 ? "Z" : " ")));

		cmdOption[0] = (char *) g_strdup (programCmd);
		cmdOption[1] = (char *) g_strdup (deviceName);
		cmdOption[2] = (char *) g_strdup ("tmp/.cxpbackup");
		cmdOption[3] = (char *) NULL;

	}
	else
	{
		sprintf (programCmd, "xvf");
		cmdOption[0] = (char *) g_strdup (programCmd);
		cmdOption[1] = (char *) g_strdup (deviceName);
		cmdOption[2] = (char *) g_strdup ("tmp/.cxpbackup");
		cmdOption[3] = (char *) NULL;
	}

#ifdef	DEBUG8
	fprintf (stdout, "compressNo  [%d]\n", cxprestore->compressNo);
	fprintf (stdout, "deviceNo    [%d]\n", cxprestore->deviceNo);
	fprintf (stdout, "programName [%s]\n", programName);
	fprintf (stdout, "cmdOption0  [%s]\n", cmdOption[0]);
	fprintf (stdout, "cmdOption1  [%s]\n", cmdOption[1]);
	fprintf (stdout, "cmdOption2  [%s]\n", cmdOption[2]);
#endif




	/* ꥹȥѻҥץ */
	cxprestore->savePid = -1;
	if (!(cxprestore->headPid = fork ()))
	{
		gtk_main_quit ();

		/* ޤʤ */
		sleep (2);

		/* ǥ쥯ȥư */
		chdir (cxprestore->backupList);

		/* ѥե򥪡ץ */
		cxprestore->normalFd =
			open (cxprestore->normalLog, O_WRONLY | O_CREAT,
			      0644);
		cxprestore->errorFd =
			open (cxprestore->errorLog, O_WRONLY | O_CREAT, 0644);

		/* ƣĤ򥳥ԡ */
		if (cxprestore->normalFd > 0)
		{
			dup2 (cxprestore->normalFd, 1);
			close (cxprestore->normalFd);
		}
		if (cxprestore->errorFd > 0)
		{
			dup2 (cxprestore->errorFd, 2);
			close (cxprestore->errorFd);
		}

		/* exec ؿǼ¹Ԥ */
		execl (programName, programName, cmdOption[0], cmdOption[1],
		       cmdOption[2], NULL);

		exit (0);
	}

	if (cxprestore->headPid <= 0)
	{
#ifdef DEBUG8
		fprintf (stdout, "Child Process error..\n");
#endif

		/* ҥץεư˼ */
		messageView ("ҥץεư˼Ԥޤ");

		remove (cxprestore->backupList);
		remove (cxprestore->normalLog);
		remove (cxprestore->errorLog);
		return (0);

	}
	else
	{

		cxprestore_headWindow ();

	}

	return (0);
}

int cxprestore_headWindow ()
{
	GtkWidget *vbox1;
	GtkWidget *hbox2;
	GtkWidget *label1;
	GtkWidget *hbox1;
	GtkWidget *vbox2;
	GtkWidget *hbox3;
	GtkWidget *swin;
	int x, y, w, h;
	int showx, showy;

	w = gdk_screen_width ();
	h = gdk_screen_height ();
	x = w / 2;
	y = h / 2;

#ifdef DEBUG8
	fprintf (stdout, "cxprestore_headWindow start ...\n");
#endif

	cxprestore->headWindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_object_set_data (GTK_OBJECT (cxprestore->headWindow),
			     "headWindow", cxprestore->headWindow);

	gtk_widget_set_usize (cxprestore->headWindow, 400, 100);
	gtk_widget_set_uposition (cxprestore->headWindow, (x - 400 * 0.5),
				  (y - 100 * 0.5));

	gtk_window_set_policy (GTK_WINDOW (cxprestore->headWindow), FALSE,
			       FALSE, FALSE);
	gtk_window_set_title (GTK_WINDOW (cxprestore->headWindow),
			      "ǡƼ");
	gtk_widget_show (cxprestore->headWindow);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->headWindow),
				  "vbox1", vbox1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);
	gtk_container_add (GTK_CONTAINER (cxprestore->headWindow), vbox1);

	hbox2 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox2);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->headWindow),
				  "hbox2", hbox2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox2);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox2, FALSE, TRUE, 20);

	label1 = gtk_label_new ("֤ǡƤǤ");
	gtk_widget_ref (label1);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->headWindow),
				  "label1", label1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label1);
	gtk_box_pack_start (GTK_BOX (hbox2), label1, FALSE, FALSE, 0);

	hbox1 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox1);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->headWindow),
				  "hbox1", hbox1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox1);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, TRUE, 5);

	headBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (headBtn);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->headWindow),
				  "headBtn", headBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (headBtn);
	gtk_box_pack_start (GTK_BOX (hbox1), headBtn, FALSE, FALSE, 0);


	/* ܥ󥤥٥ */
	gtk_signal_connect_object (GTK_OBJECT (headBtn), "clicked",
				   (GtkSignalFunc) stopHeadFunc,
				   GTK_OBJECT (cxprestore->headWindow));

#ifdef DEBUG8
	fprintf (stdout, "cxprestore_headWindow start ...\n");
#endif

	return (0);
}

int stopHeadFunc ()
{

#ifdef DEBUG8
	fprintf (stdout, "stopHeadFunc start ...\n");
#endif
	/* ҥץؽλΤȯԤ */
	if (cxprestore->headPid > 0)
		kill (cxprestore->headPid, SIGTERM);

	cxprestore_headWindowClose ();
#ifdef DEBUG8
	fprintf (stdout, "stopHeadFunc end ...\n");
#endif
}

int cxprestore_headWindowClose ()
{
	BDINFO *bdinfo;
	int totalcount;
	int k;
	struct stat fileinfo;
	char filename[1024];
	char buff[1024];
	char *viewname[4];
	char *ptr;
	FILE *fp;
	char command[1024];

#ifdef DEBUG8
	fprintf (stdout, "cxprestore_headWindowClose start ...\n");
#endif
	gtk_widget_hide (cxprestore->headWindow);
	gtk_widget_destroy (cxprestore->headWindow);

	/* 򻲾Ȥƥ顼뤫ɤĴ٤ */
	stat (cxprestore->errorLog, &fileinfo);
	if (fileinfo.st_size > 0)
	{
		errorView
			("顼ȯƤޤץǧƲ");
		if ((fp = fopen (cxprestore->errorLog, "r")) != (FILE *) NULL)
		{
			while (fgets (buff, sizeof (buff), fp) != 0)
			{
				errorAppend (buff);
			}
			fclose (fp);
		}
	}

	/* ǥǡꥹȤɽ */
	sprintf (filename, "%s/tmp/.cxpbackup", cxprestore->backupList);

#ifdef	DEBUG8
	fprintf (stdout, "filename [%s]\n", filename);
#endif

	if ((fp = fopen (filename, "r")) != (FILE *) NULL)
	{
		bdinfo = &cxprestore->root;
		totalcount = 0;

		k = -1;
		while (fgets (buff, sizeof (buff), fp) != 0)
		{
			if ((ptr = strchr (buff, '\n')) != NULL)
				*ptr = (char) NULL;

			k++;
			if (k == 0)
				continue;

			if (bdinfo->bfinfo[totalcount] == (BFINFO *) NULL)
			{
				bdinfo->bfinfo[totalcount] =
					(BFINFO *) malloc (sizeof (BFINFO));
				memset (bdinfo->bfinfo[totalcount], 0x00,
					sizeof (BFINFO));
			}
#ifdef	DEBUG8
			fprintf (stdout, "buff [%s]\n", buff);
#endif
			bdinfo->bfinfo[totalcount]->fname = g_strdup (buff);
			bdinfo->bfinfo[totalcount]->select = DIR_VIEW_SELECT;
			totalcount++;
		}
		fclose (fp);

		bdinfo->count = totalcount;

		gtk_clist_freeze (GTK_CLIST (cxprestore->showList));
		gtk_clist_clear (GTK_CLIST (cxprestore->showList));

		totalcount = 0;
		printRestoreDirectory (&cxprestore->root, -1, &totalcount);

		gtk_clist_thaw (GTK_CLIST (cxprestore->showList));


		messageView ("˥ǡƤǤޤ");
	}
	else
	{
		messageView ("Υǥˤϥꥹȥǡޤ");
	}

	sprintf (command, "%s/tmp/.cxpbackup", cxprestore->backupList);
#ifdef	DEBUG8
	fprintf (stdout, "remove file [%s]\n", command);
#endif
	remove (cxprestore->backupList);

#if 0
	sprintf (command, "rmdir %s", cxprestore->backupList);
	cxprestore->savePid = -1;
	cxprestore->headPid = -1;
	system (command);
#endif

	remove (cxprestore->normalLog);
	remove (cxprestore->errorLog);

#ifdef DEBUG8
	fprintf (stdout, "cxprestore_headWindowClose end ...\n");
#endif

}
