/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxprestore.h"

extern CxpRestore *cxprestore;

extern int stopSaveFunc ();
extern int cxprestore_showWindowClose ();

static GtkWidget *stopBtn;

int startBtnFunc (GtkWidget * widget, gpointer data)
{
	FILE *restoreFp;
	char command[1024];
	char programName[256];
	char programCmd[1024];
	char localName[1024];
	char deviceName[256];
	char *cmdOption[12];
	char *baseDir;
	int status;


	baseDir = gtk_entry_get_text (GTK_ENTRY (cxprestore->restoreEntry));

	if (baseDir == (char *) NULL)
	{
		messageView ("꤬ꤵƤޤ");
		return (0);
	}
	if (strlen (baseDir) <= 0)
	{
		messageView ("꤬ꤵƤޤ");
		return (0);
	}

	if (access (baseDir, F_OK))
	{
		messageView ("β¸ߤޤ");
		return (0);
	}


	/* ꥹȥץκ() */
	cxprestore->compressFlag = 0;
	if (GTK_TOGGLE_BUTTON (cxprestore->dataRadioBtn1)->active)
	{
		cxprestore->compressFlag = 1;
	}
	if (GTK_TOGGLE_BUTTON (cxprestore->dataRadioBtn2)->active)
	{
		cxprestore->compressFlag = 0;
	}

	/* ꥹȥץκ() */
	cxprestore->restoreFlag = 0;
	if (GTK_TOGGLE_BUTTON (cxprestore->compressRadioBtn1)->active)
	{
		cxprestore->restoreFlag = 1;
	}
	if (GTK_TOGGLE_BUTTON (cxprestore->compressRadioBtn2)->active)
	{
		cxprestore->restoreFlag = 0;
	}

	compressRadioFunc (cxprestore->compressMenu, (gpointer) NULL);
	deviceRadioFunc (cxprestore->deviceMenu, (gpointer) NULL);

	{
		int _compNo, _devNo, _k, _m, _i, _total;

		_total = 0;
		for (_i = 0; _i < cxprestore->devinf.device_kensu; _i++)
		{
			if (cxprestore->devinf.device[_i].backupFlag == 1)
				continue;
			_total++;
		}

		_compNo = 1 - cxprestore->compressNo;
		_devNo = (_total - 1) - cxprestore->deviceNo;
		cxprestore->compressNo = _compNo;

		_m = 0;
		for (_k = 0; _k < cxprestore->devinf.device_kensu; _k++)
		{
			if (cxprestore->devinf.device[_k].backupFlag != 0)
				continue;

			if (_devNo == _m)
			{
				_devNo = _k;
				break;
			}
			_m++;

		}

		cxprestore->deviceNo = _devNo;
	}

	/* ̾κ */
	sprintf (localName, "/tmp/.cxprestore.%d_%d.log",
		 cxprestore->uid, cxprestore->pid);
	sprintf (command, "touch %s", localName);
	cxprestore->savePid = -1;
	system (command);
	cxprestore->normalLog = g_strdup (localName);

	/* ٹκ */
	sprintf (localName, "/tmp/.cxprestore.%d_%d.err",
		 cxprestore->uid, cxprestore->pid);
	sprintf (command, "touch %s", localName);
	cxprestore->savePid = -1;
	system (command);
	cxprestore->errorLog = g_strdup (localName);

	/* ꥹȥꥹȤκ */
	sprintf (localName, "/tmp/.cxprestore.%d_%d",
		 cxprestore->uid, cxprestore->pid);
	cxprestore->restoreList = g_strdup (localName);


	/* ǥХ̾μ */
	sprintf (deviceName, "%s",
		 cxprestore->devinf.device[cxprestore->deviceNo].path);

	/* TARޥɺ */
	sprintf (programName, "/bin/tar");

	if (cxprestore->compressFlag == 1)
	{
		if (cxprestore->restoreFlag == 0)
		{
			sprintf (programCmd, "xTf%s",
				 (cxprestore->compressNo == 0 ? "z" :
				  (cxprestore->compressNo == 1 ? "Z" : " ")));

			cmdOption[0] = (char *) g_strdup (programCmd);
			cmdOption[1] =
				(char *) g_strdup (cxprestore->restoreList);
			cmdOption[2] = (char *) g_strdup (deviceName);
			cmdOption[3] = (char *) NULL;
		}
		else
		{
			sprintf (programCmd, "xf%s",
				 (cxprestore->compressNo == 0 ? "z" :
				  (cxprestore->compressNo == 1 ? "Z" : " ")));

			cmdOption[0] = (char *) g_strdup (programCmd);
			cmdOption[1] = (char *) g_strdup (deviceName);
			cmdOption[2] = (char *) NULL;
			cmdOption[3] = (char *) NULL;
		}

	}
	else
	{
		if (cxprestore->restoreFlag == 0)
		{
			sprintf (programCmd, "xvTf");
			cmdOption[0] = (char *) g_strdup (programCmd);
			cmdOption[1] =
				(char *) g_strdup (cxprestore->restoreList);
			cmdOption[2] = (char *) g_strdup (deviceName);
			cmdOption[3] = (char *) NULL;
		}
		else
		{
			sprintf (programCmd, "xvf");
			cmdOption[0] = (char *) g_strdup (programCmd);
			cmdOption[1] = (char *) g_strdup (deviceName);
			cmdOption[2] = (char *) NULL;
			cmdOption[3] = (char *) NULL;
		}
	}

	if (cxprestore->restoreFlag == 0)
	{
		/* ꥹȥѥǡꥹȤκ */
		if ((restoreFp =
		     fopen (cxprestore->restoreList, "w")) == (FILE *) NULL)
		{
			/* 񤭹ߥץ˼ */
			messageView ("ꥹȥꥹȤκ˼Ԥޤ");

			remove (cxprestore->restoreList);
			return (0);
		}
		status = makeRestoreList (restoreFp);
		fclose (restoreFp);

		if (status <= 0)
		{
			messageView ("ꥹȥǡޤ");
			return (0);
		}
	}

#ifdef	DEBUG8
	fprintf (stdout, "compressNo  [%d]\n", cxprestore->compressNo);
	fprintf (stdout, "deviceNo    [%d]\n", cxprestore->deviceNo);
	fprintf (stdout, "programName [%s]\n", programName);
	fprintf (stdout, "cmdOption0  [%s]\n", cmdOption[0]);
	fprintf (stdout, "cmdOption1  [%s]\n", cmdOption[1]);
	if (cxprestore->restoreFlag == 0)
		fprintf (stdout, "cmdOption3  [%s]\n", cmdOption[3]);
#endif

	/* ꥹȥѻҥץ */
	cxprestore->headPid = -1;
	if (!(cxprestore->savePid = fork ()))
	{

		gtk_main_quit ();

		/* ޤʤ */
		sleep (2);

		/* ǥ쥯ȥư */
		chdir (baseDir);

		/* ѥե򥪡ץ */
		cxprestore->normalFd =
			open (cxprestore->normalLog, O_WRONLY | O_CREAT,
			      0644);
		cxprestore->errorFd =
			open (cxprestore->errorLog, O_WRONLY | O_CREAT, 0644);

		/* ƣĤ򥳥ԡ */
		if (cxprestore->normalFd > 0)
		{
			dup2 (cxprestore->normalFd, 1);
			close (cxprestore->normalFd);
		}
		if (cxprestore->errorFd > 0)
		{
			dup2 (cxprestore->errorFd, 2);
			close (cxprestore->errorFd);
		}

		/* exec ؿǼ¹Ԥ */
		if (cxprestore->restoreFlag == 0)
			execl (programName, programName, cmdOption[0],
			       cmdOption[1], cmdOption[2], NULL);
		else
			execl (programName, programName, cmdOption[0],
			       cmdOption[1], NULL);

		exit (0);
	}

	if (cxprestore->savePid <= 0)
	{
		/* ҥץεư˼ */
		messageView ("ҥץεư˼Ԥޤ");

		remove (cxprestore->restoreList);
		remove (cxprestore->normalLog);
		remove (cxprestore->errorLog);
		return (0);

	}
	else
	{

		cxprestore_showWindow ();

	}

	return (0);
}

int cxprestore_showWindow ()
{
	GtkWidget *vbox1;
	GtkWidget *hbox2;
	GtkWidget *label1;
	GtkWidget *hbox1;
	GtkWidget *vbox2;
	GtkWidget *hbox3;
	GtkWidget *swin;
	int x, y, w, h;
	int showx, showy;

	w = gdk_screen_width ();
	h = gdk_screen_height ();
	x = w / 2;
	y = h / 2;

#ifdef DEBUG8
	fprintf (stdout, "cxprestore_showWindow start ...\n");
#endif

	cxprestore->saveWindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_object_set_data (GTK_OBJECT (cxprestore->saveWindow),
			     "saveWindow", cxprestore->saveWindow);

	gtk_widget_set_usize (cxprestore->saveWindow, 400, 100);
	gtk_widget_set_uposition (cxprestore->saveWindow, (x - 400 * 0.5),
				  (y - 100 * 0.5));

	gtk_window_set_policy (GTK_WINDOW (cxprestore->saveWindow), FALSE,
			       FALSE, FALSE);
	gtk_window_set_title (GTK_WINDOW (cxprestore->saveWindow),
			      "ꥹȥ");
	gtk_widget_show (cxprestore->saveWindow);

	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox1);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->saveWindow),
				  "vbox1", vbox1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox1);
	gtk_container_add (GTK_CONTAINER (cxprestore->saveWindow), vbox1);

	hbox2 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox2);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->saveWindow),
				  "hbox2", hbox2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox2);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox2, FALSE, TRUE, 20);

	label1 = gtk_label_new ("򤵤줿ǡꥹȥƤޤ");
	gtk_widget_ref (label1);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->saveWindow),
				  "label1", label1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label1);
	gtk_box_pack_start (GTK_BOX (hbox2), label1, FALSE, FALSE, 0);

	hbox1 = gtk_hbox_new (TRUE, 0);
	gtk_widget_ref (hbox1);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->saveWindow),
				  "hbox1", hbox1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox1);
	gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, TRUE, 5);

	stopBtn = gtk_button_new_with_label ("  ");
	gtk_widget_ref (stopBtn);
	gtk_object_set_data_full (GTK_OBJECT (cxprestore->saveWindow),
				  "stopBtn", stopBtn,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (stopBtn);
	gtk_box_pack_start (GTK_BOX (hbox1), stopBtn, FALSE, FALSE, 0);


	/* ܥ󥤥٥ */
	gtk_signal_connect_object (GTK_OBJECT (stopBtn), "clicked",
				   (GtkSignalFunc) stopSaveFunc,
				   GTK_OBJECT (cxprestore->saveWindow));

#ifdef DEBUG8
	fprintf (stdout, "cxprestore_showWindow start ...\n");
#endif

	return (0);
}

int stopSaveFunc ()
{

#ifdef DEBUG8
	fprintf (stdout, "stopSaveFunc start ...\n");
#endif
	/* ҥץؽλΤȯԤ */
	if (cxprestore->savePid > 0)
		kill (cxprestore->savePid, SIGTERM);

	cxprestore_showWindowClose ();
#ifdef DEBUG8
	fprintf (stdout, "stopSaveFunc end ...\n");
#endif
}

int cxprestore_showWindowClose ()
{
	struct stat fileinfo;
	char buff[1024];
	FILE *fp;

#ifdef DEBUG8
	fprintf (stdout, "cxprestore_showWindowClose start ...\n");
#endif
	gtk_widget_hide (cxprestore->saveWindow);
	gtk_widget_destroy (cxprestore->saveWindow);

	cxprestore->saveMode = 0;

	/* 򻲾Ȥƥ顼뤫ɤĴ٤ */
	stat (cxprestore->errorLog, &fileinfo);
	if (fileinfo.st_size > 0)
	{
		errorView
			("顼ȯƤޤ顼ƤǧƲ");
		if ((fp = fopen (cxprestore->errorLog, "r")) != (FILE *) NULL)
		{
			while (fgets (buff, sizeof (buff), fp) != 0)
			{
				errorAppend (buff);
			}
			fclose (fp);
		}
	}
	else
	{
		messageView
			("˥ꥹȥλޤפˤʤäФƲ");
	}

	remove (cxprestore->restoreList);
	remove (cxprestore->normalLog);
	remove (cxprestore->errorLog);

#ifdef DEBUG8
	fprintf (stdout, "cxprestore_showWindowClose end ...\n");
#endif

}
