/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxprestore.h"

extern CxpRestore *cxprestore;

void sigChildFunc (signum)
     int signum;
{
	pid_t pid;
	int status;

#ifdef	DEBUG8
	fprintf (stdout, "sigChildFunc function savePid [%d]....\n",
		 cxprestore->savePid);
	fflush (stdout);
#endif

	if (cxprestore->savePid > 0)
	{
		while ((pid =
			waitpid (cxprestore->savePid, &status,
				 WNOHANG)) != -1)
		{
#ifdef	DEBUG8
			fprintf (stdout,
				 "pid(%d) : exit child status .... status => %d (0x%04x)\n",
				 pid, status, status);
			fflush (stdout);
#endif
			cxprestore_showWindowClose ();
			break;
		}
		cxprestore->savePid = 0;
	}

	if (cxprestore->headPid > 0)
	{
		while ((pid =
			waitpid (cxprestore->headPid, &status,
				 WNOHANG)) != -1)
		{
#ifdef	DEBUG8
			fprintf (stdout,
				 "pid(%d) : exit child status .... status => %d (0x%04x)\n",
				 pid, status, status);
			fflush (stdout);
#endif
			cxprestore_headWindowClose ();
			break;
		}
		cxprestore->headPid = 0;
	}
}
