/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"

CxpSysinfo *cxpsysinfo;

/*
 * Cxpsysinfo Version Header
 *
 * version  date        log
 *  1.0.0   1999/09/12  first released.
 *  1.0.1   1999/09/30  text view -> list view changed.
 *                      pararell port add.
 *  1.0.2   1999/10/16  vmware loading dmesg error buf fix.
 *  1.0.3   2000/04/17  main exit code is ZERO add.
 *  1.0.4   2000/08/01  cxpmanager start add.
 *
 */

void cxpsysinfo_init ()
{
	GtkWidget *hbox;
	GtkWidget *label;
	GtkWidget *btn;
	char buff[1024];
	char vbuff[1024];
	int i, n, size;
	char *viewname[3];

	cxpsysinfo = (CxpSysinfo *) g_malloc (sizeof (CxpSysinfo));

	/* ưɣĤμ */
	cxpsysinfo->uid = getuid ();
	cxpsysinfo->gid = getgid ();

	/* ƥɤ߹ */
	getSystemInfomation (&(cxpsysinfo->info));

	/* ١Υɥ */
	cxpsysinfo->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect (GTK_OBJECT (cxpsysinfo->window), "destroy",
			    GTK_SIGNAL_FUNC (gtk_main_quit), NULL);
	gtk_window_set_title (GTK_WINDOW (cxpsysinfo->window), "Cxpsysinfo");
	gtk_widget_set_usize (cxpsysinfo->window, 200, 100);
	gtk_window_set_default_size (GTK_WINDOW (cxpsysinfo->window), 350,
				     250);


	/* VBOX */
	cxpsysinfo->vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (cxpsysinfo->window),
			   cxpsysinfo->vbox);
	gtk_widget_show (cxpsysinfo->vbox);


	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_end (GTK_BOX (cxpsysinfo->vbox), hbox, FALSE, FALSE, 3);
	gtk_widget_show (hbox);

	/* ܥ */
	btn = gtk_button_new_with_label ("Ĥ롡");
	gtk_signal_connect_object (GTK_OBJECT (btn), "clicked",
				   (GtkSignalFunc) gtk_main_quit, NULL);
	gtk_box_pack_end (GTK_BOX (hbox), btn, FALSE, FALSE, 10);
	gtk_widget_show (btn);

	cxpsysinfo_list_init ();

	/* ǡɽ */
	viewname[0] = g_strdup ("ƥ̾");
	viewname[1] = g_strdup (cxpsysinfo->info.ver);
	gtk_clist_append (GTK_CLIST (cxpsysinfo->clist), viewname);

	for (i = 0; i < cxpsysinfo->info.count; i++)
	{
		viewname[0] = g_strdup ("ãУ");
		viewname[1] = g_strdup (cxpsysinfo->info.cpu[i]);
		gtk_clist_append (GTK_CLIST (cxpsysinfo->clist), viewname);
	}

	sprintf (buff, "%s byte", cxpsysinfo->info.mem);
	viewname[0] = g_strdup ("");
	viewname[1] = g_strdup (buff);
	gtk_clist_append (GTK_CLIST (cxpsysinfo->clist), viewname);

	for (i = 0; i < cxpsysinfo->info.dcount; i++)
	{
		viewname[0] = g_strdup ("ǥ");
		viewname[1] = g_strdup (cxpsysinfo->info.disk[i]);
		gtk_clist_append (GTK_CLIST (cxpsysinfo->clist), viewname);
	}
	for (i = 0; i < cxpsysinfo->info.ccount; i++)
	{
		viewname[0] = g_strdup ("ãġݣңϣ");
		viewname[1] = g_strdup (cxpsysinfo->info.cdrom[i]);
		gtk_clist_append (GTK_CLIST (cxpsysinfo->clist), viewname);
	}
	for (i = 0; i < cxpsysinfo->info.fcount; i++)
	{
		viewname[0] = g_strdup ("եåԡ");
		viewname[1] = g_strdup (cxpsysinfo->info.floppy[i]);
		gtk_clist_append (GTK_CLIST (cxpsysinfo->clist), viewname);
	}
	for (i = 0; i < cxpsysinfo->info.scount; i++)
	{
		viewname[0] = g_strdup ("ӣãӣɥܡ");
		viewname[1] = g_strdup (cxpsysinfo->info.scsi[i]);
		gtk_clist_append (GTK_CLIST (cxpsysinfo->clist), viewname);
	}
	for (i = 0; i < cxpsysinfo->info.ecount; i++)
	{
		viewname[0] = g_strdup ("ܡ");
		viewname[1] = g_strdup (cxpsysinfo->info.eth[i]);
		gtk_clist_append (GTK_CLIST (cxpsysinfo->clist), viewname);
	}
	for (i = 0; i < cxpsysinfo->info.tcount; i++)
	{
		viewname[0] = g_strdup ("ꥢ");
		viewname[1] = g_strdup (cxpsysinfo->info.ttys[i]);
		gtk_clist_append (GTK_CLIST (cxpsysinfo->clist), viewname);
	}
	for (i = 0; i < cxpsysinfo->info.pcount; i++)
	{
		viewname[0] = g_strdup ("ѥ");
		viewname[1] = g_strdup (cxpsysinfo->info.pararel[i]);
		gtk_clist_append (GTK_CLIST (cxpsysinfo->clist), viewname);
	}

	/* ɥɽ */
	gtk_widget_show (cxpsysinfo->window);

	return;
}

int main (int argc, char *argv[])
{
	CxpBasePathInit ();

	/* ޥ͡㵯ư */
	cxp_manager_start ();

	gtk_set_locale ();
	gtk_init (&argc, &argv);

	cxpsysinfo_init ();

	gtk_main ();
	exit (0);
}
