/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software; 
 * 
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxplorer.h"
#include "common_image.h"

int common_image_check ( char *filename, int *width, int *height )
{
    gif_info   gifInfo;
    bmp_info   bmpInfo;
    tiff_info  tiffInfo;
    jpeg_info  jpegInfo;
    png_info   pngInfo;
    psd_info   psdInfo;

    *width = *height = 0 ;

    /*-- GIFȤƥإåƤߤ -------------------------*/
    memset( &gifInfo, 0x00, sizeof(gif_info) );
    gif_get_header( filename, &gifInfo ); 
    if(( gifInfo.width  <= 10000 && gifInfo.width > 0 )
    && ( gifInfo.height <= 10000 && gifInfo.width > 0 ))
    {
	/* ˼ǤGIFȤ */
	*width  = gifInfo.width ;
	*height = gifInfo.height ;
	return (CXP_IMAGE_GIF);
    }


    /*-- TIFFȤƥإåƤߤ -------------------------*/
    memset( &tiffInfo, 0x00, sizeof(tiff_info) );
    tiff_get_header( filename, &tiffInfo ); 
    if(( tiffInfo.width  <= 10000 && tiffInfo.width > 0 )
    && ( tiffInfo.height <= 10000 && tiffInfo.width > 0 ))
    {
	/* ˼ǤTIFFȤ */
	*width  = tiffInfo.width ;
	*height = tiffInfo.height ;
	return (CXP_IMAGE_TIFF);
    }


    /*-- JPEGȤƥإåƤߤ -------------------------*/
    memset( &jpegInfo, 0x00, sizeof(jpeg_info) );
    jpeg_get_header( filename, &jpegInfo ); 
    if(( jpegInfo.image_width  <= 10000 && jpegInfo.image_width > 0 )
    && ( jpegInfo.image_height <= 10000 && jpegInfo.image_height > 0 ))
    {
	/* ˼ǤJPEGȤ */
	*width  = jpegInfo.image_width ;
	*height = jpegInfo.image_height ;
	return (CXP_IMAGE_JPEG);
    }


    /*-- PNGȤƥإåƤߤ -------------------------*/
    memset( &pngInfo, 0x00, sizeof(png_info) );
    png_get_header( filename, &pngInfo ); 
    if(( pngInfo.width  <= 10000 && pngInfo.width > 0 )
    && ( pngInfo.height <= 10000 && pngInfo.width > 0 ))
    {
	/* ˼ǤPNGȤ */
	*width  = pngInfo.width ;
	*height = pngInfo.height ;
	return (CXP_IMAGE_PNG);
    }


    /*-- BMPȤƥإåƤߤ -------------------------*/
    memset( &bmpInfo, 0x00, sizeof(bmp_info) );
    bmp_get_header( filename, &bmpInfo ); 
    if(( bmpInfo.width  <= 10000 && bmpInfo.width > 0 )
    && ( bmpInfo.height <= 10000 && bmpInfo.width > 0 ))
    {
	/* ˼ǤBMPȤ */
	*width  = bmpInfo.width ;
	*height = bmpInfo.height ;
	return (CXP_IMAGE_BMP);
    }


    /*-- PSDȤƥإåƤߤ -------------------------*/
    memset( &psdInfo, 0x00, sizeof(psd_info) );
    psd_get_header( filename, &psdInfo ); 
    if(( psdInfo.width  <= 10000 && psdInfo.width > 0 )
    && ( psdInfo.height <= 10000 && psdInfo.width > 0 ))
    {
	/* ˼ǤPSDȤ */
	*width  = psdInfo.width ;
	*height = psdInfo.height ;
	return (CXP_IMAGE_PSD);
    }


    /* ǸޤǥåǤϤ줿ϥ顼Ȥ */
    return(CXP_IMAGE_NONE);
}
