/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software; 
 * 
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "common_image.h"

#define RANDOM_SEED 314159265
#define SCANLINE_INTERACT 1
#define SCANLINE_DISPLAY 2
#define DISPLAY_SPEED 20


gint ZeroDataBlock;

extern ImageCache image_cache ;

static gboolean scanline_cancelled = FALSE;
static gint bgcolor_red, bgcolor_green, bgcolor_blue;
static gint current_scanflags;
static gint total_scanline;
static gint last_scanline;
static gint first_scanline;

int gif_get_header(gchar *filename, gif_info *screen)
{
    FILE	*fp;
    guchar	buff[16];
    guchar	version[32];

    /* ե̾ʤ */	
    if (filename == (gchar *)NULL)
	return(-1);

    /* ե륪ץǤʤ */
    if ( (fp = fopen(filename, "rb")) == NULL )
	return(-1);
	
    if (!ReadCheckOK (fp, buff, 6))
    {
	fclose(fp);
	return(-1);
    }

    if (strncmp ((char *) buff, "GIF", 3) != 0)
    {
	fclose(fp);
	return(-1);
    }

    if ( gifVersionCheck( (gchar *)buff ) != 0 )
    {
	fclose(fp);
	return(-1);
    }

    if (!ReadCheckOK (fp, buff, 7))
    {
	fclose(fp);
	return(-1);
    }

    /* ᡼ξ */
    screen->width       = LM_to_uint (buff[0], buff[1]);
    screen->height      = LM_to_uint (buff[2], buff[3]);
    screen->BitPixel    = 2 << (buff[4] & 0x07);
    screen->ColorReso   = (((buff[4] & 0x70) >> 3) + 1);
    screen->Background  = buff[5];
    screen->AspectRatio = buff[6];

    fclose(fp);
	
    if (screen->width == 0 || screen->height == 0)
	return(-1);
	
    return(0);
}

gchar* gif_load(gchar *filename, GtkWidget *image_wid, int gif_img_width, int gif_img_height)
{
    guchar	buff[16];
    guchar	cc;
    FILE	*fp;
    GifColormap	localColorMap;
    gint	useGlobalColormap;
    gint	bitPixel;
    gint	imageCount = 0;
    gchar	version[4];
    gif_info	GifScreen;
    gif89_info	Gif89={-1, -1, -1, 0, NULL};

    /* ե̾ʤ */
    if (filename == (gchar *)NULL)
	return NULL ;

    /* ե륪ץǤʤ */
    if ( (fp = fopen(filename, "rb")) == NULL )
	return NULL ;

    if (!ReadCheckOK (fp, buff, 6))
    {
	fclose(fp);
	return NULL;
    }

    if (strncmp ((char *) buff, "GIF", 3) != 0)
    {
	fclose(fp);
	return NULL;
    }

    if ( gifVersionCheck( (gchar *)buff ) != 0 )
    {
	fclose(fp);
	return NULL;
    }

    if (!ReadCheckOK (fp, buff, 7))
    {
	fclose(fp);
	return NULL;
    }

    /* ᡼ξ */
    GifScreen.width       = LM_to_uint (buff[0], buff[1]);
    GifScreen.height      = LM_to_uint (buff[2], buff[3]);
    GifScreen.BitPixel    = 2 << (buff[4] & 0x07);
    GifScreen.ColorReso   = (((buff[4] & 0x70) >> 3) + 1);
    GifScreen.Background  = buff[5];
    GifScreen.AspectRatio = buff[6];
    GifScreen.colorMap[0] = g_malloc(sizeof(guchar) * GifScreen.BitPixel);
    GifScreen.colorMap[1] = g_malloc(sizeof(guchar) * GifScreen.BitPixel);
    GifScreen.colorMap[2] = g_malloc(sizeof(guchar) * GifScreen.BitPixel);

    if (BitSet(buff[4], LOCALCOLORMAP))
    {
	/* Global Colormap */
	if (ReadColorMap( fp, GifScreen.BitPixel, GifScreen.colorMap))
	{
	    FreeColorMap(GifScreen.colorMap);
	    fclose(fp);
	    return NULL;
	}
    }

    for(;;)
    {
	if (!ReadCheckOK (fp, &cc, 1))
	    break;

	if (cc == ';')
	    break;

	if (cc == '!')
	{
	    /* Extension */
	    if (!ReadCheckOK (fp, &cc, 1))
	    {
		FreeColorMap(GifScreen.colorMap);
		fclose(fp);
		return Gif89.comment;
	    }
	    DoExtension (fp, cc, &Gif89);
	    continue;
	}

	if (cc != ',')
	{
	    /* Not a valid start character */
	    continue;
	}

	++imageCount;

	if (!ReadCheckOK (fp, buff, 9))
	    break;

	useGlobalColormap = !BitSet (buff[8], LOCALCOLORMAP);

	bitPixel = 1 << ((buff[8] & 0x07) + 1);

	if (!useGlobalColormap)
	{
	    localColorMap[0] = g_malloc(sizeof(guchar) * bitPixel);
	    localColorMap[1] = g_malloc(sizeof(guchar) * bitPixel);
	    localColorMap[2] = g_malloc(sizeof(guchar) * bitPixel);

	    if (ReadColorMap (fp, bitPixel, localColorMap))
	    {
		FreeColorMap(localColorMap);
		break;
	    }

	    ReadImageGIF (fp,
		LM_to_uint (buff[4], buff[5]),
		LM_to_uint (buff[6], buff[7]),
		localColorMap, &Gif89,
		bitPixel,
		BitSet (buff[8], INTERLACE), imageCount,
		(guint) LM_to_uint (buff[0], buff[1]),
		(guint) LM_to_uint (buff[2], buff[3]),
		GifScreen.width,
		GifScreen.height,
		image_wid );
	    FreeColorMap(localColorMap);

	} else {
	    ReadImageGIF (fp,
		LM_to_uint (buff[4], buff[5]),
		LM_to_uint (buff[6], buff[7]),
		GifScreen.colorMap, &Gif89,
		GifScreen.BitPixel,
		BitSet (buff[8], INTERLACE), imageCount,
		(guint) LM_to_uint (buff[0], buff[1]),
		(guint) LM_to_uint (buff[2], buff[3]),
		GifScreen.width,
		GifScreen.height,
		image_wid );
	}
	/* we only need one image.
	 * I still have not decided to add animation gif support.
 	 * So break here.
	 */
	break;
    }
	
    FreeColorMap(GifScreen.colorMap);
    fclose(fp);
    return Gif89.comment;

}

gint ReadColorMap ( FILE *fp, gint number, GifColormap buffer)
{
    gint i;
    guchar rgb[3];
	
    for (i = 0; i < number; ++i)
    {
	if (!ReadCheckOK (fp, rgb, sizeof (rgb)))
	{
	    return TRUE;
	}

	buffer[CM_RED][i] = (guchar)rgb[0];
	buffer[CM_GREEN][i] = (guchar)rgb[1];
	buffer[CM_BLUE][i] = (guchar)rgb[2];
    }

    return FALSE;
}

gint FreeColorMap(GifColormap cmap)
{
    g_free(cmap[0]);
    g_free(cmap[1]);
    g_free(cmap[2]);
    return FALSE;
}

gint DoExtension (FILE *fp, int label, gif89_info *Gif89)
{
    guchar buf[256];
    gint count;

    switch (label)
    {
	case 0x01:	/* Plain Text Extension */
		break;
	case 0xff:	/* Application Extension */
		break;
	case 0xfe:	/* Comment Extension */
		while ((count = GetDataBlock (fp, buf)) != 0)
		{
		    if (Gif89->comment == NULL)
		    {
			count = (count<MAX_COMMENT_SIZE)?count:MAX_COMMENT_SIZE;
			Gif89->comment = g_malloc(sizeof(gchar) * (count + 1));
			strncpy(Gif89->comment, buf, count);
			Gif89->comment[count] = '\0';
		    }
		}
		return FALSE;
	case 0xf9:	/* Graphic Control Extension */
		(void) GetDataBlock (fp, buf);
		Gif89->disposal = (buf[0] >> 2) & 0x7;
		Gif89->inputFlag = (buf[0] >> 1) & 0x1;
		Gif89->delayTime = LM_to_uint (buf[1], buf[2]);
		if ((buf[0] & 0x1) != 0)
		    Gif89->transparent = buf[3];
		else
		    Gif89->transparent = -1;
		break;
	default:
		break;
    }

    while (GetDataBlock (fp, NULL) > 0) ;

    return FALSE;
}

gint GetDataBlock (FILE	*fp, guchar *buf)
{
    guchar count;
	
    if (!ReadCheckOK (fp, &count, 1))
	return -1;
	
    ZeroDataBlock = count == 0;
	
    if (count == 0)
	return 0;

    if (buf != NULL)
    {
	if (!ReadCheckOK (fp, buf, count))
	{
	    return -1;
	}
    } else {
	fseek(fp, count, SEEK_CUR);
    }
	
    return count;
}

gint GetCode (FILE *fp, gint code_size, gint flag)
{
    static guchar buf[280];
    static gint	curbit, lastbit, done, last_byte;
    gint i, j, ret, count;

    if (flag)
    {
	curbit  = 0;
	lastbit = 0;
	done    = FALSE;
	return 0;
    }

    if ((curbit + code_size) >= lastbit)
    {
	if (done)
	    return -1;

	buf[0] = buf[last_byte - 2];
	buf[1] = buf[last_byte - 1];
		
	if ((count = GetDataBlock (fp, &buf[2])) == 0)
	    done = TRUE;
	if (count < 0) return -1;
	last_byte = 2 + count;
	curbit = (curbit - lastbit) + 16;
	lastbit = (2 + count) * 8;
    }
	
    ret = 0;
    for (i = curbit, j = 0; j < code_size; ++i, ++j)
	ret |= ((buf[i / 8] & (1 << (i % 8))) != 0) << j;
	
    curbit += code_size;

    return ret;
}

int LWZReadByte (FILE *fp, int flag, int input_code_size)
{
    static gint fresh = FALSE;
    static gint code_size, set_code_size;
    static gint max_code, max_code_size;
    static gint firstcode, oldcode, temp;
    static gint clear_code, end_code;
    static gint table[2][(1 << MAX_LWZ_BITS)];
    static gint stack[(1 << (MAX_LWZ_BITS)) * 2], *sp;
    gint code, incode;
    register gint i;
	
    if (flag)
    {
	set_code_size = input_code_size;
	code_size = set_code_size + 1;
	clear_code = 1 << set_code_size;
	end_code = clear_code + 1;
	max_code_size = 2 * clear_code;
	max_code = clear_code + 2;

	if (GetCode (fp, 0, TRUE) < 0)
		return -1;
		
	fresh = TRUE;
		
	for (i = 0; i < clear_code; ++i)
	{
	    table[0][i] = 0;
	    table[1][i] = i;
	}

	sp = stack;
		
	return 0;
    } else if (fresh)
    {
	fresh = FALSE;
	do
	{
	    if ((temp = GetCode (fp, code_size, FALSE)) < 0)
		return -1;
	    firstcode = oldcode = temp;
	} while (firstcode == clear_code);
	return firstcode;
    }
	
    if (sp > stack)
	return *--sp;
	
    while ((code = GetCode (fp, code_size, FALSE)) >= 0)
    {
	if (code == clear_code)
	{
	    for (i = 0; i < clear_code; ++i)
	    {
		table[0][i] = 0;
		table[1][i] = i;
	    }

	    code_size = set_code_size + 1;
	    max_code_size = 2 * clear_code;
	    max_code = clear_code + 2;
	    sp = stack;
	    if ((temp = GetCode (fp, code_size, FALSE)) < 0)
		return -1;
	    firstcode = oldcode = temp;
	    return firstcode;
	} else if (code == end_code)
	{
	    gint count;

	    if (ZeroDataBlock)
		return -2;
			
	    while ((count = GetDataBlock (fp, NULL)) > 0) ;
	    return -2;
	}

	incode = code;
		
	if (code >= max_code)
	{
	    *sp++ = firstcode;
	    code = oldcode;
	}

	while (code >= clear_code && sp < stack + ((1<<MAX_LWZ_BITS)*2-1))
	{
	    *sp++ = table[1][code];
	    if (code == table[0][code])
	    {
		return -1;
	    }
	    code = table[0][code];
	}

	*sp++ = firstcode = table[1][code];

	if ((code = max_code) < (1 << MAX_LWZ_BITS))
	{
	    table[0][code] = oldcode;
	    table[1][code] = firstcode;
	    ++max_code;
	    if ((max_code >= max_code_size) && (max_code_size < (1 << MAX_LWZ_BITS)))
	    {
		max_code_size *= 2;
		++code_size;
	    }
	}
	oldcode = incode;
	if (sp > stack)
	    return *--sp;
    }
    return code;
}

gint32 ReadImageGIF (FILE *fp, gint len, gint height, GifColormap cmap,
	gif89_info *Gif89, gint ncols, gint interlace, gint number,
	guint leftpos, guint toppos, guint screenwidth, guint screenheight,
	GtkWidget *image_wid )
{
    guint *dest, *temp;
    guchar c;
    gint xpos = 0, ypos = 0, pass = 0;
    gint v;
    gboolean alpha_frame = FALSE;
    guchar   highest_used_index;
    GtkPreview *preview ;
    double nscale_w, nscale_h, nscale ;

    if (!ReadCheckOK (fp, &c, 1))
	return -1;

    if (LWZReadByte (fp, TRUE, c) < 0)
	return -1;
	
    if (number != 1)
	alpha_frame = TRUE;

    if (alpha_frame)
	dest = (guint *) g_malloc (sizeof(guint) * len * 2);
    else
	dest = (guint *) g_malloc (sizeof(guint) * len);

    preview = GTK_PREVIEW(image_wid);

    if ( len > preview->widget.allocation.width )
    {
	nscale_w = (double)preview->widget.allocation.width / (double)len;
    }else{
	nscale_w = (double)1.0 ;
    }

    if ( height > preview->widget.allocation.height )
    {
	nscale_h = (double)preview->widget.allocation.height / (double)height;
    }else{
	nscale_h = (double)1.0 ;
    }

    if ( nscale_h > nscale_w )
    {
	nscale = nscale_w ;
    }else{
	nscale = nscale_h ;
    }

    while ((v = LWZReadByte (fp, FALSE, c)) >= 0)
    {

	if (alpha_frame)
	{
	    if (((guchar)v > highest_used_index) && !(v == Gif89->transparent))
		highest_used_index = (guchar)v;
	    temp = &dest[xpos << 1];
	    temp[0] = (guint) v;
	    temp[1] = (guint) ((v == Gif89->transparent) ? 0 : 255);
	} else {
	    if ((guchar)v > highest_used_index)
		highest_used_index = (guchar)v;
	    temp = &dest[xpos];
	    temp[0] = (guint) v;
	}

	++xpos;
	if (xpos == len)
	{
	    if (gif_scanline(dest, cmap, Gif89->transparent, len, ypos, nscale, preview))
		break;

	    xpos = 0;
	    if (interlace)
	    {
		switch (pass)
		{
		    case 0:
		    case 1: ypos += 8; break;
		    case 2: ypos += 4; break;
		    case 3: ypos += 2; break;
		}
		if (ypos >= height)
		{
		    ++pass;
		    switch (pass)
		    {
			case 1: ypos = 4; break;
			case 2: ypos = 2; break;
			case 3: ypos = 1; break;
			default: goto fini;
		    }
		}
	    }else
		++ypos;
	}
	if (ypos >= height)
	    break;
    }
	
fini:
	
    if (LWZReadByte (fp, FALSE, c) >= 0) ;

    g_free (dest);
	
    return 0;
}

gint gifVersionCheck( gchar *data )
{
    char version[4];

    strncpy (version, (char *)data + 3, 3);
    version[3] = '\0';

    if ((strcmp (version, "87a") != 0)
    &&  (strcmp (version, "89a") != 0))
    {
	return(-1);
    }

    return(0);
}



void scanline_init(GdkColorContext *gcc, GtkStyle *style)
{                
        bgcolor_red = (style->bg[GTK_STATE_NORMAL]).red >> 8;
        bgcolor_green = (style->bg[GTK_STATE_NORMAL]).green >> 8;
        bgcolor_blue = (style->bg[GTK_STATE_NORMAL]).blue >> 8;
        srand(RANDOM_SEED);
}

gboolean gif_scanline(guint *buffer, guchar *cmap[], gint transparent,
	gint width, gint scanline, double nscale, GtkPreview *preview)
{
	int	nexti ;
        register gint i, k, c;
        register guchar *rgbbuffer = image_cache.buffer +
                image_cache.buffer_width * scanline * 3;

#ifdef	DEBUG7
fprintf(stdout,"-----------------------------------------------------\n");
fprintf(stdout,"preview->widget.requisition.width  -> %d\n",
preview->widget.requisition.width );
fprintf(stdout,"preview->widget.requisition.height -> %d\n",
preview->widget.requisition.height );
fprintf(stdout,"preview->widget.allocation.x       -> %d\n",
preview->widget.allocation.x );
fprintf(stdout,"preview->widget.allocation.y       -> %d\n",
preview->widget.allocation.y );
fprintf(stdout,"preview->widget.allocation.width   -> %d\n",
preview->widget.allocation.width );
fprintf(stdout,"preview->widget.allocation.height  -> %d\n",
preview->widget.allocation.height );
fprintf(stdout,"width                              -> %d\n", width );
fprintf(stdout,"nscale                             -> %lf\n", nscale );
#endif

        for (i=0, k=0; i<width*nscale; i++)
        {
		nexti = (int)( (double)i / (double)nscale ) ;
                if ((c = buffer[nexti]) == transparent)
                {
                        rgbbuffer[k] = bgcolor_red;   k++;
                        rgbbuffer[k] = bgcolor_green; k++;
                        rgbbuffer[k] = bgcolor_blue;  k++;
                } else
                {
                        rgbbuffer[k] = cmap[0][c]; k++;
                        rgbbuffer[k] = cmap[1][c]; k++;
                        rgbbuffer[k] = cmap[2][c]; k++;
                }
        }

        gtk_preview_draw_row(preview, rgbbuffer, 0, scanline*nscale, width*nscale);

        return scanline_cancelled;
}
