/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software; 
 * 
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "common_image.h"

typedef struct my_error_mgr {
	struct jpeg_error_mgr pub;	/* "public" fields */

	jmp_buf setjmp_buffer;	/* for return to caller */
} *my_error_ptr;

static struct my_error_mgr jerr;

/*
 * Here's the routine that will replace the standard error_exit method:
 */
static void my_error_exit (j_common_ptr cinfo)
{
	/* cinfo->err really points to a my_error_mgr struct, so coerce pointer */
	my_error_ptr myerr = (my_error_ptr) cinfo->err;

	/* Always display the message. */
	/* We could postpone this until after returning, if we chose. */
	/*(*cinfo->err->output_message) (cinfo);*/

	/* Return control to the setjmp point */
	longjmp (myerr->setjmp_buffer, 1);
}

gboolean jpeg_get_header(gchar *filename, jpeg_info *cinfo)
{
	FILE *infile;
	
	cinfo->err = jpeg_std_error (&jerr.pub);
	jerr.pub.error_exit = my_error_exit;

	if (setjmp (jerr.setjmp_buffer))
	{
		jpeg_destroy_decompress (cinfo);
		if (infile) fclose (infile);
		return FALSE;
	}

	if ((infile = fopen (filename, "rb")) == NULL)
	{
		return FALSE;
	}
	
	jpeg_create_decompress (cinfo);
	jpeg_stdio_src (cinfo, infile);
	jpeg_read_header (cinfo, TRUE);
	jpeg_destroy_decompress (cinfo);
	
	fclose (infile);
	return TRUE;
}

gboolean jpeg_load(gchar *filename, GtkWidget *image_wid, int jpeg_img_width, int jpeg_img_height )
{
	FILE *infile;
	JSAMPROW buffer[1];
	jpeg_info cinfo;
	GtkPreview *preview ;
	double nscale_w, nscale_h, nscale ;
	
	cinfo.err = jpeg_std_error (&jerr.pub);
	jerr.pub.error_exit = my_error_exit;

	if (setjmp (jerr.setjmp_buffer))
	{
		jpeg_destroy_decompress (&cinfo);
		if (infile) fclose (infile);
		return FALSE;
	}

	if ((infile = fopen (filename, "rb")) == NULL)
	{
		return FALSE;
	}

	preview = GTK_PREVIEW(image_wid);

	jpeg_create_decompress (&cinfo);
	jpeg_stdio_src (&cinfo, infile);
	jpeg_read_header (&cinfo, TRUE);

	if (cinfo.image_width < 0 || cinfo.num_components < 0)
	{
		fclose(infile);
		return FALSE;
	}

	if ( jpeg_img_width > preview->widget.allocation.width )
	{
	    nscale_w = (double)preview->widget.allocation.width / (double)jpeg_img_width;
	}else{
	    nscale_w = (double)1.0 ;
	}

	if ( jpeg_img_height > preview->widget.allocation.height )
	{
	    nscale_h = (double)preview->widget.allocation.height / (double)jpeg_img_height;
	}else{
	    nscale_h = (double)1.0 ;
	}
    
	if ( nscale_h > nscale_w )
	{
	    nscale = nscale_w ;
	}else{
	    nscale = nscale_h ;
	}

	cinfo.quantize_colors = FALSE;
	cinfo.do_fancy_upsampling = FALSE;
	cinfo.do_block_smoothing = FALSE;
	
	buffer[0] = (JSAMPROW)g_new (guchar, cinfo.image_width * cinfo.num_components);
	if (buffer[0] == NULL) {
		g_warning("Out of memory!");
		return FALSE;
	}

	jpeg_start_decompress (&cinfo);


	while (cinfo.output_scanline < cinfo.output_height)
	{
		jpeg_read_scanlines (&cinfo, buffer, 1);
		if ( jpeg_scanline(buffer[0], cinfo.output_width, 0, cinfo.output_scanline-1,
			cinfo.output_components, -1, 0, nscale, preview )) break;
	}

	jpeg_finish_decompress (&cinfo);
	jpeg_destroy_decompress (&cinfo);
	
	fclose(infile);

	g_free (buffer[0]);
	return TRUE;
}

