/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software; 
 * 
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "common_image.h"

#define DISPLAY_SPEED 20

#define ABS_CXP(x) (((x)>=0)?(x):(-(x)))
#define MIN_CXP(x,y) (((x)<=(y))?(x):(y))
#define MAX_CXP(x,y) (((x)>=(y))?(x):(y))

#define RANDOM_SEED 314159265

static void pixelLayerMode(guchar *,guchar *,guchar *,gint,gint,gboolean,gboolean,LayerMode);
static void rgb_to_hsv (gint *r, gint *g, gint *b);
static void hsv_to_rgb (gint *h, gint *s, gint *v);
static void rgb_to_hls (gint *r, gint *g, gint *b);
static void hls_to_rgb (gint *h, gint *l, gint *s);
static gint hls_value (gfloat n1, gfloat n2, gfloat hue);

static gint bgcolor_red, bgcolor_green, bgcolor_blue;

extern ImageCache image_cache ;

gboolean jpeg_scanline( guchar *buffer, gint width, gint left, gint scanline,
	gint components, gint pass, LayerMode mode, double nscale, GtkPreview *preview)
{
    register gint i, j, k;
    static gint alp, cur_red, cur_green, cur_blue, display_height;
    static guchar src1[4], src2[4], dest[4];
    static GdkRectangle rect;
    register guchar *rgbbuffer = image_cache.buffer +
	(image_cache.buffer_width * scanline + left) * 3;
    int nexti ;
	
    if (pass <= 0)
    {
	cur_red = bgcolor_red;
	cur_green = bgcolor_green;
	cur_blue = bgcolor_blue;
    }

#if 0
fprintf(stdout,"-------------------------------------------------\n");
fprintf(stdout,"width      -> %d\n", width );
fprintf(stdout,"scanline   -> %d\n", scanline );
fprintf(stdout,"components -> %d\n", components );
fprintf(stdout,"pass       -> %d\n", pass );
fprintf(stdout,"nscale     -> %lf\n", nscale );
#endif

#if 0
    for (i=0, j=0, k=0; i<width; i++)
#else
    for (i=0, j=0, k=0; i<width*nscale; i++)
#endif
    {

	nexti = (int)( (double)j / (double)nscale + 0.5) ;

	if (pass > 0)
	{
	    cur_red = rgbbuffer[k];
	    cur_green = rgbbuffer[k + 1];
	    cur_blue = rgbbuffer[k + 2];
	}
	switch (components)
	{
  	    case 1:
/* ?? */
#if 0
		rgbbuffer[k++] = buffer[j];
		rgbbuffer[k++] = buffer[j];
		rgbbuffer[k++] = buffer[j++];
#else
		rgbbuffer[k++] = buffer[nexti];
		rgbbuffer[k++] = buffer[nexti];
		rgbbuffer[k++] = buffer[nexti];
		j++;
#endif
		break;
	    case 2:
/* ?? */
		if (pass > 0 && mode > 0)
		{
		    src1[0] = cur_red;
		    src1[1] = cur_green;
		    src1[2] = cur_blue;
		    src1[3] = 255;
#if 0
		    src2[0] = buffer[j];
		    src2[1] = buffer[j];
		    src2[2] = buffer[j];
		    src2[3] = buffer[j+1];
#else
		    src2[0] = buffer[nexti];
		    src2[1] = buffer[nexti];
		    src2[2] = buffer[nexti];
		    src2[3] = buffer[nexti+1];
#endif
		    pixelLayerMode(src1, src2, dest, 4, 4, TRUE, TRUE, mode);
		    alp = dest[3];
		    rgbbuffer[k++] = dest[0] * alp / 255 + cur_red * (255-alp) / 255;
		    rgbbuffer[k++] = dest[1] * alp / 255 + cur_green * (255-alp) / 255;
		    rgbbuffer[k++] = dest[2] * alp / 255 + cur_blue * (255-alp) / 255;
		} else {
#if 0
		    alp = buffer[j+1];
		    rgbbuffer[k++] = buffer[j] * alp / 255 + cur_red * (255-alp) / 255;
		    rgbbuffer[k++] = buffer[j] * alp / 255 + cur_green * (255-alp) / 255;
		    rgbbuffer[k++] = buffer[j] * alp / 255 + cur_blue * (255-alp) / 255;
#else
		    alp = buffer[nexti+1];
		    rgbbuffer[k++] = buffer[nexti] * alp / 255 + cur_red * (255-alp) / 255;
		    rgbbuffer[k++] = buffer[nexti] * alp / 255 + cur_green * (255-alp) / 255;
		    rgbbuffer[k++] = buffer[nexti] * alp / 255 + cur_blue * (255-alp) / 255;
#endif
		}
		j += 2;
		break;
	    case 3:
/* OK */
		if ( nexti%3 != 0 )
		{
		    int _nexti ;
		    _nexti = ((nexti/3) + 1) * 3 ;
		    nexti = _nexti ;
		}
		rgbbuffer[k++] = buffer[nexti];   j++;
		rgbbuffer[k++] = buffer[nexti+1]; j++;
		rgbbuffer[k++] = buffer[nexti+2]; j++;
		break;
	    case 4:
/* OK */
		if (pass > 0 && mode > 0)
		{
		    src1[0] = cur_red;
		    src1[1] = cur_green;
		    src1[2] = cur_blue;
		    src1[3] = 255;
#if 0
		    src2[0] = buffer[j];
		    src2[1] = buffer[j+1];
		    src2[2] = buffer[j+2];
		    src2[3] = buffer[j+3];
		    pixelLayerMode(src1, src2, &buffer[j], 4, 4, TRUE, TRUE, mode);
#else
		    src2[0] = buffer[nexti];
		    src2[1] = buffer[nexti+1];
		    src2[2] = buffer[nexti+2];
		    src2[3] = buffer[nexti+3];
		    pixelLayerMode(src1, src2, &buffer[nexti], 4, 4, TRUE, TRUE, mode);
#endif
		}
#if 0
		alp = buffer[j+3];
		rgbbuffer[k++] = buffer[j++] * alp / 255 + cur_red * (255-alp) / 255;
		rgbbuffer[k++] = buffer[j++] * alp / 255 + cur_green * (255-alp) / 255;
		rgbbuffer[k++] = buffer[j++] * alp / 255 + cur_blue * (255-alp) / 255;
		j++;
#else
		nexti = (int)( (double)j / (double)nscale + 0.5) ;
		if ( nexti%4 != 0 )
		{
		    int _nexti ;
		    _nexti = ((nexti/4) + 1) * 4 ;
		    nexti = _nexti ;
		}
		alp = buffer[nexti+3];
		rgbbuffer[k++] = buffer[nexti] * alp / 255 + cur_red * (255-alp) / 255; j++;
		rgbbuffer[k++] = buffer[nexti+1] * alp / 255 + cur_green * (255-alp) / 255; j++;
		rgbbuffer[k++] = buffer[nexti+2] * alp / 255 + cur_blue * (255-alp) / 255; j++;
		j++;
#endif
		break;
	    default:
		break;
	}
    }

#if 0
    gtk_preview_draw_row(preview, rgbbuffer, left, scanline, width);
#else
    gtk_preview_draw_row(preview, rgbbuffer, left, scanline*nscale, width*nscale);
#endif

    return FALSE;
}

static void pixelLayerMode( guchar *src1, guchar *src2, guchar *dest,
	gint b1, gint b2, gboolean ha1, gboolean ha2, LayerMode mode)
{
    static gint b, alpha, t, t2, red1, green1, blue1, red2, green2, blue2;

    alpha = (ha1 || ha2) ? max(b1, b2) - 1 : b1;
    switch (mode)
    {
	case DISSOLVE_MODE:
	    for (b = 0; b < alpha; b++)
		dest[b] = src2[b];
	    /*  dissolve if random value is > opacity  */
	    t = (rand() & 0xFF);
	    dest[alpha] = (t > src2[alpha]) ? 0 : src2[alpha];
	    break;
	case MULTIPLY_MODE:
	    for (b = 0; b < alpha; b++)
		dest[b] = (src1[b] * src2[b]) / 255;
	    if (ha1 && ha2)
		dest[alpha] = min(src1[alpha], src2[alpha]);
	    else if (ha2)
		dest[alpha] = src2[alpha];
	    break;
	case SCREEN_MODE:
	    for (b = 0; b < alpha; b++)
		dest[b] = 255 - ((255 - src1[b]) * (255 - src2[b])) / 255;
	    if (ha1 && ha2)
		dest[alpha] = min(src1[alpha], src2[alpha]);
	    else if (ha2)
		dest[alpha] = src2[alpha];
	    break;
	case OVERLAY_MODE:
	    for (b = 0; b < alpha; b++)
	    {
		/* screen */
		t = 255 - ((255 - src1[b]) * (255 - src2[b])) / 255;
		/* mult */
		t2 = (src1[b] * src2[b]) / 255;
		dest[b] = (t * src1[b] + t2 * (255 - src1[b])) / 255;
	    }
	    if (ha1 && ha2)
		dest[alpha] = min(src1[alpha], src2[alpha]);
	    else if (ha2)
		dest[alpha] = src2[alpha];
	    break;
	case DIFFERENCE_MODE:
	    for (b = 0; b < alpha; b++)
	    {
		t = src1[b] - src2[b];
		dest[b] = (t < 0) ? -t : t;
	    }
	    if (ha1 && ha2)
		dest[alpha] = min(src1[alpha], src2[alpha]);
	    else if (ha2)
		dest[alpha] = src2[alpha];
	    break;
	case ADDITION_MODE:
	    for (b = 0; b < alpha; b++)
	    {
		t = src1[b] + src2[b];
		dest[b] = (t > 255) ? 255 : t;
	    }
	    if (ha1 && ha2)
		dest[alpha] = min(src1[alpha], src2[alpha]);
	    else if (ha2)
		dest[alpha] = src2[alpha];
	    break;
	case SUBTRACT_MODE:
	    for (b = 0; b < alpha; b++)
	    {
		t = (gint)src1[b] - (gint)src2[b];
		dest[b] = (t < 0) ? 0 : t;
	    }
	    if (ha1 && ha2)
		dest[alpha] = min(src1[alpha], src2[alpha]);
	    else if (ha2)
		dest[alpha] = src2[alpha];
	    break;
	case DARKEN_ONLY_MODE:
	    for (b = 0; b < alpha; b++)
	    {
		t = src1[b];
		t2 = src2[b];
		dest[b] = (t < t2) ? t : t2;
	    }
	    if (ha1 && ha2)
		dest[alpha] = min(src1[alpha], src2[alpha]);
	    else if (ha2)
		dest[alpha] = src2[alpha];
	    break;
	case LIGHTEN_ONLY_MODE:
	    for (b = 0; b < alpha; b++)
	    {
		t = src1[b];
		t2 = src2[b];
		dest[b] = (t < t2) ? t2 : t;
	    }
	    if (ha1 && ha2)
		dest[alpha] = min(src1[alpha], src2[alpha]);
	    else if (ha2)
		dest[alpha] = src2[alpha];
	    break;
	case HUE_MODE:
	case SATURATION_MODE:
	case VALUE_MODE:
	    red1 = src1[0]; green1 = src1[1]; blue1 = src1[2];
	    red2 = src2[0]; green2 = src2[1]; blue2 = src2[2];
	    rgb_to_hsv (&red1, &green1, &blue1);
	    rgb_to_hsv (&red2, &green2, &blue2);
	    switch (mode)
	    {
		case HUE_MODE:
		    red1 = red2;
		    break;
		case SATURATION_MODE:
		    green1 = green2;
		    break;
		case VALUE_MODE:
		    blue1 = blue2;
		    break;
		default:
		    break;
	    }
	    hsv_to_rgb (&red1, &green1, &blue1);
	    dest[0] = red1; dest[1] = green1; dest[2] = blue1;
	    if (ha1 && ha2)
		dest[3] = min(src1[3], src2[3]);
	    else if (ha2)
		dest[3] = src2[3];
	    break;
	case COLOR_MODE:
	    red1 = src1[0]; green1 = src1[1]; blue1 = src1[2];
	    red2 = src2[0]; green2 = src2[1]; blue2 = src2[2];
	    rgb_to_hls (&red1, &green1, &blue1);
	    rgb_to_hls (&red2, &green2, &blue2);
	    red1 = red2;
	    blue1 = blue2;
	    hls_to_rgb (&red1, &green1, &blue1);
	    dest[0] = red1; dest[1] = green1; dest[2] = blue1;
	    if (ha1 && ha2)
		dest[3] = min(src1[3], src2[3]);
	    else if (ha2)
		dest[3] = src2[3];
	    break;
	case NORMAL_MODE:
	default:
	    for (b = 0; b < b2; b++) dest[b] = src2[b];
	    break;
    }
}

static void rgb_to_hsv (gint *r, gint *g, gint *b)
{
    gint red, green, blue;
    gfloat h, s, v;
    gint min, max;
    gint delta;

    h = 0.0;

    red = *r;
    green = *g;
    blue = *b;

    if (red > green) {
	if (red > blue)
	    max = red;
	else
	    max = blue;

	if (green < blue)
	    min = green;
	else
	    min = blue;
    } else {
	if (green > blue)
	    max = green;
	else
	    max = blue;

	if (red < blue)
	    min = red;
	else
	    min = blue;
    }

    v = max;

    if (max != 0)
	s = ((max - min) * 255) / (gfloat) max;
    else
	s = 0;

    if (s == 0)
	h = 0;
    else {
	delta = max - min;
	if (red == max)
	    h = (green - blue) / (gfloat) delta;
	else if (green == max)
	    h = 2 + (blue - red) / (gfloat) delta;
	else if (blue == max)
	    h = 4 + (red - green) / (gfloat) delta;
	h *= 42.5;

	if (h < 0)
	    h += 255;
	if (h > 255)
	    h -= 255;
    }

    *r = h;
    *g = s;
    *b = v;
}

static void hsv_to_rgb (gint *h, gint *s, gint *v)
{
    gfloat hue, saturation, value;
    gfloat f, p, q, t;

    if (*s == 0) {
	*h = *v;
	*s = *v;
	*v = *v;
    } else {
	hue = *h * 6.0 / 255.0;
	saturation = *s / 255.0;
	value = *v / 255.0;

	f = hue - (gint) hue;
	p = value * (1.0 - saturation);
	q = value * (1.0 - (saturation * f));
	t = value * (1.0 - (saturation * (1.0 - f)));

	switch ((gint) hue)
	{
	    case 0:
		*h = value * 255;
		*s = t * 255;
		*v = p * 255;
		break;
	    case 1:
		*h = q * 255;
		*s = value * 255;
		*v = p * 255;
		break;
	    case 2:
		*h = p * 255;
		*s = value * 255;
		*v = t * 255;
		break;
	    case 3:
		*h = p * 255;
		*s = q * 255;
		*v = value * 255;
		break;
	    case 4:
		*h = t * 255;
		*s = p * 255;
		*v = value * 255;
		break;
	    case 5:
		*h = value * 255;
		*s = p * 255;
		*v = q * 255;
		break;
	}
    }
}

static void rgb_to_hls (gint *r, gint *g, gint *b)
{
    gint red, green, blue;
    gfloat h, l, s;
    gint min, max;
    gint delta;

    red = *r;
    green = *g;
    blue = *b;

    if (red > green) {
	if (red > blue)
	    max = red;
	else
	    max = blue;

	if (green < blue)
	    min = green;
	else
	    min = blue;
    } else {
	if (green > blue)
	    max = green;
	else
	    max = blue;

	if (red < blue)
	    min = red;
	else
	    min = blue;
    }

    l = (max + min) / 2.0;

    if (max == min) {
	s = 0.0;
	h = 0.0;
    } else {
	delta = (max - min);

	if (l < 128)
	    s = 255 * (gfloat) delta / (gfloat) (max + min);
	else
	    s = 255 * (gfloat) delta / (gfloat) (511 - max - min);

	if (red == max)
	    h = (green - blue) / (gfloat) delta;
	else if (green == max)
	    h = 2 + (blue - red) / (gfloat) delta;
	else
	    h = 4 + (red - green) / (gfloat) delta;

	h = h * 42.5;

	if (h < 0)
	    h += 255;
	if (h > 255)
	    h -= 255;
    }

    *r = h;
    *g = l;
    *b = s;
}

static gint hls_value (gfloat n1, gfloat n2, gfloat hue)
{
    gfloat value;

    if (hue > 255)
	hue -= 255;
    else if (hue < 0)
	hue += 255;

    if (hue < 42.5)
	value = n1 + (n2 - n1) * (hue / 42.5);
    else if (hue < 127.5)
	value = n2;
    else if (hue < 170)
	value = n1 + (n2 - n1) * ((170 - hue) / 42.5);
    else
	value = n1;

    return (gint) (value * 255);
}

static void hls_to_rgb (gint *h, gint *l, gint *s)
{
    gfloat hue, lightness, saturation;
    gfloat m1, m2;

    hue = *h;
    lightness = *l;
    saturation = *s;

    if (saturation == 0) {
	/*  achromatic case  */
	*h = lightness;
	*l = lightness;
	*s = lightness;
    } else {
	if (lightness < 128)
	    m2 = (lightness * (255 + saturation)) / 65025.0;
	else
	    m2 = (lightness + saturation - (lightness * saturation)/255.0) / 255.0;

	m1 = (lightness / 127.5) - m2;

	/*  chromatic case  */
	*h = hls_value (m1, m2, hue + 85);
	*l = hls_value (m1, m2, hue);
	*s = hls_value (m1, m2, hue - 85);
    }
}
