/*
 * Cxp -- Cxp Desktop Environment Software.
 * Copyright (C) 1998-2000 Konta <hatakeda@mbm.sphere.ne.jp>
 *
 * This program is free software;
 *
 *                                             hatakeda@mbm.sphere.ne.jp
 *      Cxp Home Page http://www1.sphere.ne.jp/hatakeda/cxplorer/index.html
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "cxpcommon.h"
#include "cxpsocket.h"

int cxpsocket_serverstart (void)
{
	struct sockaddr_un address;
	int sock, conn;
	size_t addrLength;

	if ((sock = socket (PF_UNIX, SOCK_STREAM, 0)) < 0)
	{
#ifdef	DEBUG_SOCKET
		fprintf (stderr, "socket error\n");
#endif
		return (-1);
	}

	unlink (CXPSOCKET_NAME);

	address.sun_family = AF_UNIX;
	strcpy (address.sun_path, CXPSOCKET_NAME);

	addrLength = sizeof (address.sun_family) + strlen (address.sun_path);

	if (bind (sock, (struct sockaddr *) &address, addrLength))
	{
#ifdef	DEBUG_SOCKET
		fprintf (stderr, "bind error\n");
#endif
		close (sock);
		return (-2);
	}

	if (listen (sock, 5))
	{
#ifdef	DEBUG_SOCKET
		fprintf (stderr, "listen error\n");
#endif
		close (sock);
		return (-3);
	}

	while ((conn =
		accept (sock, (struct sockaddr *) &address,
			&addrLength)) >= 0)
	{
#ifdef	DEBUG_SOCKET
		fprintf (stdout, "---- getting data\n");
#endif
		close (conn);
	}

	if (conn < 0)
	{
#ifdef	DEBUG_SOCKET
		fprintf (stderr, "accept error\n");
#endif
		close (sock);
	}

	close (sock);

	return (0);
}
