#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "callbacks.h"
#include "cxpdd.h"
#include "interface.h"
#include "support.h"
#include "fileselect.h"

Cxpdd cxpdd;

/*
	Initialize
*/
void
on_gwMainWin_show (GtkWidget * widget, gpointer user_data)
{
	GtkWidget *glVersionLabel;
	GString *gsVersion;

	/* Set version string. */
	glVersionLabel = lookup_widget (widget, "glVersionLabel");
	gsVersion = g_string_new ("");
	g_string_printf (gsVersion, "%s %s", PACKAGE, VERSION);
	gtk_label_set_text (GTK_LABEL (glVersionLabel), gsVersion->str);

	cxpdd.window = lookup_widget (widget, "gwMainWin");
	cxpdd.device = lookup_widget (widget, "geDeviceFile");
	cxpdd.writeimg = lookup_widget (widget, "geWriteImageEntry");
	cxpdd.spinbtn = lookup_widget (widget, "spinbutton1");
	cxpdd.readimg = lookup_widget (widget, "geReadImageEntry");

	g_string_free (gsVersion, TRUE);
}

/*
	Browse file for write.
*/
void
on_gbBrowseButton1_clicked (GtkButton * button, gpointer user_data)
{
	FileSelect (cxpdd.writeimg);
}

/*
	Browse file for read.
*/
void
on_gbBrowseButton2_clicked (GtkButton * button, gpointer user_data)
{
	FileSelect (cxpdd.readimg);
}

void
on_gbWriteButton_clicked (GtkButton * button, gpointer user_data)
{
	GString *gsFileName;
	GtkWidget *dialog;

	gsFileName =
		g_string_new (gtk_entry_get_text
			      (GTK_ENTRY (cxpdd.writeimg)));

	/* ToDo: Check device. */

	/* Check file exists. */
	if (g_file_test (gsFileName->str, G_FILE_TEST_IS_REGULAR) != TRUE)
	{
		dialog = gtk_message_dialog_new (GTK_WINDOW (cxpdd.window),
						 GTK_DIALOG_DESTROY_WITH_PARENT,
						 GTK_MESSAGE_ERROR,
						 GTK_BUTTONS_CLOSE,
						 _
						 ("file '%s' is not exists!"),
						 gsFileName->str);
		gtk_dialog_run (GTK_DIALOG (dialog));
		gtk_widget_destroy (dialog);
		g_string_free (gsFileName, TRUE);
		return;
	}

	/* ToDo: Execute dd async. */
	execute_dd (cxpdd.window, gsFileName->str,
		    gtk_entry_get_text (GTK_ENTRY (cxpdd.device)));

	g_string_free (gsFileName, TRUE);
}


gboolean
on_gwMainWin_delete_event (GtkWidget * widget,
			   GdkEvent * event, gpointer user_data)
{
	gtk_main_quit ();

	return FALSE;
}

void
on_gbReadButton_clicked (GtkButton * button, gpointer user_data)
{
	GString *gsFileName;
	GtkWidget *dialog;

	gsFileName =
		g_string_new (gtk_entry_get_text (GTK_ENTRY (cxpdd.readimg)));

	/* ToDo: Check device. */

	/* Check file exists. */
	if (g_file_test (gsFileName->str, G_FILE_TEST_EXISTS) == TRUE)
	{
		dialog = gtk_message_dialog_new (GTK_WINDOW (cxpdd.window),
						 GTK_DIALOG_DESTROY_WITH_PARENT,
						 GTK_MESSAGE_ERROR,
						 GTK_BUTTONS_CLOSE,
						 _
						 ("file '%s' is already exists!"),
						 gsFileName->str);
		gtk_dialog_run (GTK_DIALOG (dialog));
		gtk_widget_destroy (dialog);
		g_string_free (gsFileName, TRUE);
		return;
	}

	/* ToDo: Check file safety. */

	execute_dd (cxpdd.window,
		    gtk_entry_get_text (GTK_ENTRY (cxpdd.device)),
		    gsFileName->str);

	g_string_free (gsFileName, TRUE);
}
