/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "fileselect.h"

GtkWidget *gwDialog;
GtkWidget *gwReturnEntry;

void
FileSelect (GtkWidget * gwEntry)
{
	GtkWidget *gwOkButton;
	GtkWidget *gwCancelButton;
	
	gwReturnEntry = gwEntry;

	gwDialog = gtk_file_selection_new (_("Select file name"));
	gtk_container_set_border_width (GTK_CONTAINER (gwDialog), 10);
	gtk_window_set_modal (GTK_WINDOW (gwDialog), TRUE);
	gtk_window_set_destroy_with_parent (GTK_WINDOW (gwDialog),
					    TRUE);

	gwOkButton = GTK_FILE_SELECTION (gwDialog)->ok_button;
	gtk_widget_show (gwOkButton);
	GTK_WIDGET_SET_FLAGS (gwOkButton, GTK_CAN_DEFAULT);

	gwCancelButton = GTK_FILE_SELECTION (gwDialog)->cancel_button;
	gtk_widget_show (gwCancelButton);
	GTK_WIDGET_SET_FLAGS (gwCancelButton, GTK_CAN_DEFAULT);

	g_signal_connect ((gpointer) gwOkButton, "clicked",
				  G_CALLBACK (on_gwOkButton_clicked),
				  NULL);
	g_signal_connect ((gpointer) gwCancelButton, "clicked",
				  G_CALLBACK (on_gwCancelButton_clicked),
				  NULL);
	
	gtk_widget_show (gwDialog);
}

void
on_gwOkButton_clicked (GtkButton * button, gpointer user_data)
{
	gtk_entry_set_text (GTK_ENTRY (gwReturnEntry),
			    gtk_file_selection_get_filename
			    (GTK_FILE_SELECTION (gwDialog)));

	gtk_widget_destroy (GTK_WIDGET (gwDialog));
}

void
on_gwCancelButton_clicked (GtkButton * button, gpointer user_data)
{
	gtk_widget_destroy (gwDialog);
}
