#include <Analizer/DAQBuilderRoot1DHist.hh>
#include <DataRecord/DAQBuilderDataRecord.hh>
#include <DataRecord/DAQBuilderDataSection.hh>
#include <DataRecord/DAQBuilderDataSegment.hh>
#include <DataRecord/DAQBuilderDataElement.hh>
#include <Primitives/DAQBuilderString.hh>
#include <System/DAQBuilderSystem.hh>

namespace DAQBuilder
{
  void Root1DHist::_finalize()
  {
 //   start();
   if(_canvas !=NULL)
     delete _canvas;
   if(RootSystem::_app!=NULL)
     delete RootSystem::_app;
   //gROOT -> Reset(0);
  }
  const DString Root1DHist::toString() const 
  {
    DString returnString = "NumHist     : ";
    returnString += String::digitToString((DLong)_numHist);
    returnString += "\n";
    returnString += "CanvasName  : ";
    returnString += _canvasName;
    returnString += "\n";
    returnString += "CanvasTitle : ";
    returnString += _canvasTitle;
    returnString += "\n";
    returnString += "CanvasWidth : ";
    returnString += String::digitToString((DLong)_canvasWidth);
    returnString += "\n";
    returnString += "CanvasHeight : ";
    returnString += String::digitToString((DLong)_canvasHeight);
    return returnString;
  }
  void Root1DHist::analyzeDataStructuer( const DataSection & record )
  { 
    _numHist = 0;
    DataSection aSection = record;
	for( std::map<DString,DataSegment>::iterator siter = aSection.begin() ;
	     siter != aSection.end();
	     siter++)
	  {
	    DString segStr = siter -> first;
	    for( std::map<DString,DataElement>::iterator giter = (siter->second).begin() ;
		 giter != (siter->second).end();
		 giter++)
	      {
		DString eleStr = giter -> first;
		DString tmp    ;
		tmp               += segStr;
		tmp               += ".";
		tmp               += eleStr;
		_histNames.push_back(tmp);
		//_currentData.push_back(giter->second);
		_hist.push_back( new TH1F(tmp.c_str() , 
					  tmp.c_str() , 
					  _numBins , 
					  0 ,
					  4096
					  ));
	      }
	    _numHist += (siter->second).size();
	  }
    
    this -> createCanvas();
    bestDivide();
  }
  void Root1DHist::analyzeDataStructuer( const DataRecord & record )
  { 
    _record = record;
    _numHist = 0;
    for( std::map<DLong,DataSection>::iterator iter = _record.begin() ;
	 iter != _record.end();
	 iter++)
      {
	//DString secStr = iter -> first;
	for( std::map<DString,DataSegment>::iterator siter = (iter->second).begin() ;
	     siter != (iter->second).end();
	     siter++)
	  {
	    DString segStr = siter -> first;
	    for( std::map<DString,DataElement>::iterator giter = (siter->second).begin() ;
		 giter != (siter->second).end();
		 giter++)
	      {
		DString eleStr = giter -> first;
		DString tmp    ;
		tmp               += segStr;
		tmp               += ".";
		tmp               += eleStr;
		_histNames.push_back(tmp);
		//_currentData.push_back(giter->second);
		_hist.push_back( new TH1F(tmp.c_str() , 
					  tmp.c_str() , 
					  4096 , 
					  0 ,
					  4096
					  ));
	      }
	    _numHist += (siter->second).size();
	  }
      }
    
    this -> createCanvas();
    bestDivide();
  }
  
  void Root1DHist::bestDivide()
  {
    int i ;
    for(i = 0 ; i < _numHist ; i++ )
      {
	if( i*i >=  _numHist ) 
	  {
            _canvas ->Divide( i , i );
	    return;
	  }
	else if( i*(i+1)>=  _numHist)
	  {
	    _canvas ->Divide( i+1 , i);
	    return;
	  }
      }
  }
  
  void Root1DHist::drawHist( const DataRecord & bin )
  {
    for(std::map<DLong,DataSection>::const_iterator iter = bin.begin();
                                              iter!= bin.end();
                                              iter++){
      drawHist(iter->second);
     }
  }

  void Root1DHist::drawHist( const DataSection & bin )
  {
    if(RootSystem::_app == NULL)
    {
       RootSystem::_app = new TApplication("Root1DHist",0,NULL);
       //gROOT -> Reset(0);
    }
    if( _hist.size() == 0 )
      analyzeDataStructuer( bin );
    
    DataSection dr = bin;

    int i = 0;
    _currentData.clear();
    for( std::map<DString,DataSegment>::iterator siter = dr.begin() ;
	 siter != dr.end();
	 siter++)
      {
	for( std::map<DString,DataElement>::iterator giter = (siter->second).begin() ;
	     giter != (siter->second).end();
	     giter++)
	  {
	    _currentData.push_back(giter->second);
	    _canvas->cd( i+1 );
	    _hist[ i ] -> Fill((giter->second).getInt());
	    _hist[ i ] -> Draw();
	    i++;
	  }
	_numHist += (siter->second).size();
      }
    _canvas -> Update();
  }
  void Root1DHist::run()
  {
    DInt processID = 0;
    processID = fork();
    if( processID == 0 )
      {
        if(RootSystem::_app!=NULL) ;
        // RootSystem::_app -> Run();
	//std::cout<<"deleted"<<std::endl;
	if(_canvas !=NULL)
	 delete _canvas;
        if(RootSystem::_app!=NULL) 
	 delete RootSystem::_app;
	System::exit(0);
      }
    else if( processID >= 1  )
      {
        DInt status;
	::wait(&status);
      }
    else
      {
        perror("fork");
      }
  }
  DBool   Root1DHist::operator   ==(const Root1DHist & right ) const 
  {
    DBool aBool = *((Thread*)this) ==  *((Thread*)&right);
    aBool |= _numHist  == right._numHist;
    aBool |=  _canvas   ==right._canvas;
    aBool |= _canvasName==right._canvasName;
    aBool |= _canvasTitle==right._canvasTitle;
    aBool |= _canvasWidth==right._canvasWidth;
    aBool |= _canvasHeight==right._canvasHeight;
    aBool |= _numBins==right._numBins;
    aBool |= _hist==right._hist;
    aBool |= _record==right._record;
    aBool |= _histNames==right._histNames;
    aBool |= _currentData ==right._currentData;
    return aBool;
  }
  DBool   Root1DHist::operator   !=(const Root1DHist & right ) const 
  {
    DBool aBool = *((Thread*)this) !=  *((Thread*)&right);
    aBool |= _numHist  != right._numHist;
    aBool |=  _canvas   !=right._canvas;
    aBool |= _canvasName!=right._canvasName;
    aBool |= _canvasTitle!=right._canvasTitle;
    aBool |= _canvasWidth!=right._canvasWidth;
    aBool |= _canvasHeight!=right._canvasHeight;
    aBool |= _numBins!=right._numBins;
    aBool |= _hist!=right._hist;
    aBool |= _record!=right._record;
    aBool |= _histNames!=right._histNames;
    aBool |= _currentData !=right._currentData;
    return aBool;
  }
}
