#ifndef  _DAQBuilderRoot1DHist_HH
#define  _DAQBuilderRoot1DHist_HH
#include <Analizer/DAQBuilderRootSystem.hh>
#include <System/DAQBuilderThread.hh>
#include <DataRecord/DAQBuilderDataRecord.hh>
#include <DataRecord/DAQBuilderDataElement.hh>
#include <Exception/DAQBuilderNullPointerException.hh>
namespace DAQBuilder
{
  class Root1DHist : public Thread
  {
  protected :
    virtual               void _finalize();
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  protected :
    DInt                               _numHist;
    TCanvas                     *       _canvas;
    DString                         _canvasName;
    DString                        _canvasTitle;
    Int_t                          _canvasWidth;
    Int_t                         _canvasHeight;
    Int_t                              _numBins;
    
    std::vector< TH1F * >              _hist;
    DataRecord                         _record;
    std::vector<DString>               _histNames;
    std::vector<DataElement>           _currentData;
  protected:   
    virtual  void                      bestDivide();
    virtual  void                      analyzeDataStructuer( const DataRecord  & _record );
    virtual  void                      analyzeDataStructuer( const DataSection & section );
    virtual  void                      createCanvas();
     
  public :
    Root1DHist();
    Root1DHist( const Root1DHist & right );
    virtual ~Root1DHist();
    virtual  Root1DHist& operator=( const Root1DHist& right);
    virtual DBool   operator   ==(const Root1DHist & right ) const ;
    virtual DBool   operator   !=(const Root1DHist & right ) const ;
  public:
    virtual  const DString  toString() const ;
    virtual  void        drawHist( const DataRecord   &_record  );
    virtual  void        drawHist( const DataSection  &_record  );
    virtual  void        printHist( const DString & filename );
    virtual  TCanvas *   getCanvas();

    virtual  void        setCanvasName(  const  DString  &  _canvasName );
    virtual  void        setCanvasTitle( const  DString  &  _canvasTitle );
    virtual  void        setCanvasWidth(  const DInt    &  _canvasWidth );
    virtual  void        setCanvasHeight( const DInt    &  _canvasHeight );

    virtual  void        setNumBins( const DInt& numBins );
    virtual const DataRecord&  getDataRecord() const ;

    virtual void         run();
  };
  
  inline Root1DHist::Root1DHist()
    :Thread(),_numHist(0),_canvas(NULL),
     _canvasName("NoName"),_canvasTitle("NoTitle"),_canvasWidth(1024),_canvasHeight(768),_numBins(4096),
     _hist(std::vector<TH1F*>()),_record(),_histNames(std::vector<DString>())
     ,_currentData(std::vector<DataElement>())
  {
    _setType();
    _setParentClasses();
  }
  
  inline Root1DHist::Root1DHist( const Root1DHist& right )
    :Thread(*((Thread*)&right)),_numHist(right._numHist),_canvas(right._canvas),_numBins(right._numBins),
     _canvasName(right._canvasName),_canvasTitle(right._canvasTitle),
     _canvasWidth(right._canvasWidth),_canvasHeight(right._canvasHeight),
     _hist(right._hist),_record(right._record),_histNames(right._histNames)
    ,_currentData(right._currentData)
  {

  }
  inline Root1DHist::~Root1DHist()
  {
    _finalize();
  }
  inline Root1DHist& Root1DHist::operator=( const Root1DHist& right )
  {
    *((Thread*)this) =    *((Thread*)&right);
    _numHist       = right._numHist;
    _canvas        = right._canvas;
    _canvasName    = right._canvasName;
    _canvasTitle   = right._canvasTitle;
    _canvasWidth   = right._canvasWidth;
    _canvasHeight  = right._canvasHeight;
    _numBins       = right._numBins;
    _hist          = right._hist;
    _record        = right._record;
    return *this;
  }
  inline const DataRecord&  Root1DHist::getDataRecord() const 
  {
    return _record;
  }
  inline void Root1DHist::_setType()
  {
    _type="Root1DHist";
  }
  inline void Root1DHist::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("Runnable");
    _parentClasses.insert("Thread");
  }
  inline  void        Root1DHist::setCanvasName( const DString& canvasName )
  {
    _canvasName = canvasName;
  }
  inline  void        Root1DHist::setCanvasTitle( const DString& canvasTitle )
  {
    _canvasTitle = canvasTitle;
  }
  inline  void        Root1DHist::setCanvasWidth(  const DInt&  canvasWidth )
  {
    _canvasWidth = (Int_t)(canvasWidth);
  }
  inline  void        Root1DHist::setCanvasHeight( const DInt&  canvasHeight )
  {
    _canvasHeight = (Int_t)(canvasHeight);
  }
  
  inline  void  Root1DHist::createCanvas()
  {
    if(RootSystem::_app == NULL)
    {
      RootSystem::_app = new TApplication("Root1DHist",0,NULL);
      //gROOT -> Reset(0);
    }
    _canvas = new TCanvas(_canvasName.c_str(),
			  _canvasTitle.c_str(),
			  _canvasWidth,
			  _canvasHeight );
  }
  
  inline  void  Root1DHist::printHist( const DString& filename )
  {
    _canvas -> Print( filename.c_str() );
  }
  inline  TCanvas *        Root1DHist::getCanvas()
  {
    return this -> _canvas;
  }
  inline  void        Root1DHist::setNumBins( const DInt& numBins)
  {
    _numBins = numBins;
  }
}
#endif
