#include <Analizer/DAQBuilderRootFile.hh>
#include <DataRecord/DAQBuilderDataSection.hh>
#include <DataRecord/DAQBuilderDataSegment.hh>
#include <DataRecord/DAQBuilderDataElement.hh>
#include <Primitives/DAQBuilderString.hh>
#include <System/DAQBuilderSystem.hh>

namespace DAQBuilder
{
  const DString RootFile::_extension = ".root";
  const DString RootFile::toString() const 
  {
    DString returnString = "FileName   : ";
    returnString += this -> _fileName;
    returnString += "\n";
    returnString += "TreeName   : ";
    returnString += this -> _treeName;
    returnString += "\n";
    returnString += "TreeTitle  : ";
    returnString += this -> _treeTitle;
    return returnString;
  }

  void RootFile::_analizeDataStructuer()
  { 
    const DataRecord&  _record  = _tmpDataRecord;
    std::vector< std::pair<DString,DInt> > segmentInformation;

    std::map<DLong,DataSection>::const_iterator iter = _record.begin() ;
    for( std::map<DString,DataSegment>::const_iterator siter = (iter->second).begin() ;
	 siter != (iter->second).end();
	 siter++)
      {
	
	DString     segStr  =  siter -> first;
	DInt         numCh  = (siter -> second).size();
	segmentInformation.push_back(std::pair<DString,DInt>(segStr,numCh));
      }

    std::vector< DULong * >      dataList;    
    for( std::vector< std::pair< DString , DInt> > :: const_iterator iter = segmentInformation.begin();
	 iter != segmentInformation.end();
	 iter ++)
      {
	DString tmp= iter -> first;
	tmp            += "[";
	tmp            += String::digitToString((DLong)(iter -> second ));
	tmp            +="]/I";
        DULong *  tmpData = new DULong[ iter -> second ];
        dataList.push_back(tmpData);
	_tree->Branch((iter->first).c_str(),tmpData,tmp.c_str());
      }

    for( std::map<DLong,DataSection>::const_iterator iter = _record.begin() ;
	 iter != _record.end();
	 iter++)
      {
	std::vector< DULong * >::iterator diter = dataList.begin();
	for( std::map<DString,DataSegment>::const_iterator siter = (iter->second).begin() ;
	     siter != (iter->second).end();
	     siter++ , diter ++ )
	  {
	    DInt i = 0;
	    for( std::map<DString,DataElement>::const_iterator giter = (siter->second).begin() ;
		 giter != (siter->second).end();
		 giter++)
	      {
		(*diter)[ i ] = 0;
		if(giter->second.isUShort())
		(*diter)[ i ] = (DULong)(giter -> second).getUShort();
		else if(giter->second.isUInt())
		(*diter)[ i ] = (DULong)(giter -> second).getUInt();
		else if(giter->second.isULong())
		(*diter)[ i ] = (DULong)(giter -> second).getULong();
		else 
		(*diter)[ i ] = (DULong)(giter -> second).getULong();
                i++;
	      }
	  }
	_tree -> Fill();
      }
   
     
    for( std::vector< DULong * > :: iterator iter = dataList.begin();
	 iter != dataList.end();
	 iter ++)
      {
	delete *iter ;
	*iter = NULL;
      }
   
    segmentInformation.clear(); 
    dataList.clear(); 
    _file->cd();
    _tree->Write();

  }
  void RootFile::run()
  {
    DInt processID = 0;
    processID = fork();
    if( processID == 0 )
      {
	_lock();
	RootSystem::_app = new TApplication("DAQ-Builder",0,NULL);
        gROOT -> Reset(0);
	if(!_tree)
	  _tree= new TTree(_treeName.c_str(),_treeTitle.c_str());
	if(!_file)
	  _file= new TFile(_fileName.c_str(),"RECREATE");
	_analizeDataStructuer();
	_file->Close();
	_unLock();
	delete RootSystem::_app;
      }
    else if( processID >= 1  )
      {
        DInt status;
	::wait(&status);
      }
    else
      {
        perror("fork");
      }
  }
  void RootFile::write( const DataRecord & dataRecord )
  {
    _tmpDataRecord = dataRecord;
    start();
  }
  void RootFile::_new( const DString & _fileName )
  {
    setFileName(_fileName);
  }
  void RootFile::_delete()
      throw(NullPointerException *)
  {
    if( _file == NULL )
      throw new NullPointerException("RootFile::_delete()");
    delete _file;
    if( _tree == NULL )
      throw new NullPointerException("RootFile::_delete()");
    delete _tree;
  }
  DBool   RootFile::operator   ==(const RootFile & right ) const 
  {
    DBool aBool = *((Thread*)this) ==  *((Thread*)&right);
    aBool |= _fileName==right._fileName;
    aBool |= _treeName==right._treeName;
    aBool |= _treeTitle==right._treeTitle;
    return aBool;	  
  }
  DBool   RootFile::operator   !=(const RootFile & right ) const 
  {
    DBool aBool = *((Thread*)this) !=  *((Thread*)&right);
    aBool |= _fileName!=right._fileName;
    aBool |= _treeName!=right._treeName;
    aBool |= _treeTitle!=right._treeTitle;
    return aBool;
  }
}
