#ifndef  _DAQBuilderRootFile_HH
#define  _DAQBuilderRootFile_HH
#include <Analizer/DAQBuilderRootSystem.hh>
#include <System/DAQBuilderThread.hh>
#include <DataRecord/DAQBuilderDataRecord.hh>
#include <Exception/DAQBuilderNullPointerException.hh>
namespace DAQBuilder
{
  class RootFile : public Thread
  {
  protected :
    virtual               void _finalize();
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  protected :
    DString                        _fileName;
    DString                        _treeName;
    DString                        _treeTitle;
    static const DString           _extension;
    TFile                         *    _file;
    TTree                         *    _tree;
    DataRecord                         _tmpDataRecord;
  protected:
    virtual  void                      _analizeDataStructuer();
    virtual  void                      _new( const DString& _fileName );
    virtual  void                      _delete()
      throw(NullPointerException *);
  
  public :
    RootFile( const DString& _fileName = "NoName");
    RootFile( const RootFile & right );
    virtual ~RootFile();
    virtual RootFile&  operator=( const RootFile& right );
    virtual DBool   operator   ==(const RootFile & right ) const ;
    virtual DBool   operator   !=(const RootFile & right ) const ;
  public :
    virtual  const DString toString() const ;
    virtual  void        run();
    virtual  void        write( const DataRecord  &_record  );

    virtual  void          setFileName(  const  DString  &  _fileName );
    virtual  const DString& getFileName() const ;

    virtual  void          setTreeName( const  DString  &   _treeName );
    virtual  const DString& getTreeName() const ;

    virtual  void          setTreeTitle( const  DString  &  _treeTitle );
    virtual  const DString& getTreeTitle() const ;

  };
  
  inline RootFile::RootFile( const DString& fileName )
    :Thread(),_fileName(fileName),_treeName("NoTreeName"),_treeTitle("NoTreeTitle"),
     _file(NULL),_tree(NULL),_tmpDataRecord()
  {
    _setType();
    _setParentClasses();
    _new(_fileName);
  }
  
  inline RootFile::RootFile( const RootFile& right )
    :Thread(*((Thread*)&right)),_fileName(right._fileName),_treeName(right._treeName),_treeTitle(right._treeTitle),
     _file(right._file),_tree(right._tree),_tmpDataRecord(right._tmpDataRecord)
  {
  }
  inline RootFile::~RootFile()
  {
    _finalize();
  }
  inline RootFile& RootFile::operator=( const RootFile& right )
  {
    *((Thread*)this)=    *((Thread*)&right);
    _fileName = right._fileName; 
    _treeName = right._treeName;
    _treeTitle= right._treeTitle;
    _file     = right._file;
    _tree     = right._tree;
    return *this;
  }
  inline void RootFile::_finalize()
  {
    try{
      _delete();
    }catch(Exception * e ){
    }
  }
  inline void RootFile::_setType()
  {
    _type="RootFile";
  }
  inline void RootFile::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("Runnable");
    _parentClasses.insert("Thread");
  }
  inline  void        RootFile::setFileName( const DString& fileName )
  {
    _fileName  = fileName;
    _fileName += RootFile::_extension;
  }
  inline  const DString&        RootFile::getFileName( ) const 
  {
    return _fileName;
  }
  inline  void        RootFile::setTreeName( const DString& treeName )
  {
    _treeName = treeName;
  }
  inline  const DString&        RootFile::getTreeName( ) const 
  {
    return _treeName;
  }
  inline  void        RootFile::setTreeTitle( const DString& treeTitle )
  {
    this -> _treeTitle = treeTitle;
  }
  inline  const DString&        RootFile::getTreeTitle( ) const 
  {
    return _treeTitle;
  }
}
#endif
