#ifndef _DAQBuilderClass_HH
#define _DAQBuilderClass_HH
#include <DAQBuilderSerializableObject.hh>
#include <Exception/DAQBuilderSameNameBindedException.hh>
#include <Exception/DAQBuilderFieldNotFoundException.hh>
#include <Exception/DAQBuilderMethodNotFoundException.hh>

namespace DAQBuilder
{
  class Field;
  class Method;
  class Class : public SerializableObject
  {
  protected :
    DString                       _className;
    std::map<DString , Field  >   _fields;
    std::map<DString , Method >   _methods;
  protected:
    virtual               void _finalize();    
 
    virtual  void              _setType();
    virtual  void              _setParentClasses();
    Instance *                 _cloneableInstance;
  public :
    virtual void                       serialize(   DByte *& ,       DULong&  );
    virtual ByteArray                  serialize();
    virtual void                       unSerialize( DByte *  , const DULong&  );
    virtual Cloneable *                clone() const ;
  public : 
    virtual  const DString toString() const ;
    Class( const DString& _className ="NoClassName" );
    Class( const Class & right );
    virtual ~Class();
    Class&                    operator=(const Class & right );
    virtual DBool   operator   ==(const Class & right ) const ;
    virtual DBool   operator   !=(const Class & right ) const ;
    virtual DBool             equals( const Object * o );    
    virtual DBool             equals( const Class  & o );   
  public:
    const DString&        getClassName()const ;
    void                      setField( Field& field ) 
      throw( SameNameBindedException  *);
    const Field&              getField( const DString& fieldName )  const 
      throw( FieldNotFoundException  *);   

    void                      setMethod( Method& method ) 
      throw( SameNameBindedException  *);
    const Method&             getMethod( const DString& methodName )const 
      throw( MethodNotFoundException *);

    const DString         getFieldTableString() const ;
    const DString         getMethodTableString() const ;
   
    StringList            getMethodList() const ;
    StringList            getFieldList() const ;

  };

  inline DBool Class::equals(const Object * o )
  {
    if(!findParent(_type,o))
      return false;
    return equals(*((Class*)o));
  }
  inline DBool Class::equals(const Class&   o )
  {
    DBool aBool   = (_className      ==o._className);

    /*
    aBool        |= (_fields == o._fields) ;
    aBool        |= (_methods== o._methods) ;
    */

    return aBool;
  }
}
#endif
