#include <Class/DAQBuilderField.hh>
#include <System/IO/DAQBuilderByteArrayOutputStream.hh>
#include <System/IO/DAQBuilderPrimitiveDataOutputStream.hh>
#include <System/IO/DAQBuilderByteArrayInputStream.hh>
#include <System/IO/DAQBuilderPrimitiveDataInputStream.hh>
namespace DAQBuilder
{
  const std::string   Field::toString() const
  {
    DString returnString = "Type : ";
    returnString += this -> getTypeName();
    returnString += "\n";
    returnString += "Name : ";
    returnString += this -> getFieldName();
    returnString += "\n";
    returnString += "Class: ";
    returnString += this -> getAffiliationClassName();
    return returnString;
  }
  void                  Field::serialize( DByte *& data , DULong& dataSize )
  {
    ByteArrayOutputStream aBAO;   
    PrimitiveDataOutputStream aPDO(&aBAO);
    aPDO.writeString(_fieldName);
    aPDO.writeString(_typeName);
    aPDO.writeString(_affiliationClass);
    return aBAO.toByteArray(data,dataSize);
  }
  ByteArray                  Field::serialize()
  {
    ByteArrayOutputStream aBAO;   
    PrimitiveDataOutputStream aPDO(&aBAO);
    aPDO.writeString(_fieldName);
    aPDO.writeString(_typeName);
    aPDO.writeString(_affiliationClass);
    return aBAO.toByteArray();
  }
  void                  Field::unSerialize( DByte * data , const DULong & dataSize )
  {
    ByteArrayInputStream     aBAI(data,dataSize);   
    PrimitiveDataInputStream aPDI(&aBAI);
    _fieldName        = aPDI.readString();
    _typeName         = aPDI.readString();
    _affiliationClass = aPDI.readString();
  }
  Cloneable *                Field::clone() const 
  {
    return (Cloneable*) new Field(*this);
  }
  DBool   Field::operator   ==(const Field & right ) const 
  {
    DBool aBool = *((SerializableObject*)this) ==  *((SerializableObject*)&right);
    aBool |= _fieldName       ==right._fieldName;
    aBool |= _typeName        ==right._typeName;
    aBool |= _affiliationClass==right._affiliationClass;
    return aBool;
  }
  DBool   Field::operator   !=(const Field & right ) const 
  {
    DBool aBool = *((SerializableObject*)this) !=  *((SerializableObject*)&right);
    aBool |= _fieldName       !=right._fieldName;
    aBool |= _typeName        !=right._typeName;
    aBool |= _affiliationClass!=right._affiliationClass;
    return aBool;
  }
}
