#ifndef _DAQBuilderField_HH
#define _DAQBuilderField_HH
#include <DAQBuilderSerializableObject.hh>
namespace DAQBuilder
{
  class  Field : public SerializableObject
  { 
  protected :
    DString _fieldName       ;
    DString _typeName        ;
    DString _affiliationClass;
  protected:
    virtual void _finalize();
    virtual void _setType();
    virtual void _setParentClasses();
  public :
    virtual void                       serialize(   DByte *& ,       DULong&  );
    virtual ByteArray                  serialize();
    virtual void                       unSerialize( DByte *  , const DULong&  );
    virtual Cloneable *                clone() const ;
  public  :
    Field();
    Field( const DString& _fieldName ,
	   const DString& _typeName,
	   const DString& _affiliationClass = "NoAffiliationClass") ;

    Field( const Field& right);

    virtual ~Field();    
    virtual DBool equals(const Object * o );
    virtual DBool equals(const Field&   o );
    virtual const DString  toString() const;
    const DString& getFieldName() const ;
    const DString& getTypeName() const ;
    const DString& getAffiliationClassName() const ;
    void               setAffiliationClassName( const DString& affiliationClassName );
  public:
    Field&             operator=( const Field& right );
    virtual DBool   operator   ==(const Field & right ) const ;
    virtual DBool   operator   !=(const Field & right ) const ;
  };

  inline  Field::Field()  
:SerializableObject()
   {
    this -> _setType();
    this -> _setParentClasses();
    }
  inline   Field::Field( const DString& fieldName ,
			 const DString& typeName,
			 const DString& affiliationClass) 
    :SerializableObject(),_fieldName( fieldName ),_typeName( typeName ),_affiliationClass( affiliationClass )
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  inline Field::Field( const Field& right)
    :SerializableObject(*((SerializableObject*)&right)),_fieldName( right._fieldName ),
     _typeName( right._typeName ),_affiliationClass( right._affiliationClass )
  {
  }
  inline Field&             Field::operator=( const Field& right)
  {  
    *((Object*)this)  =     *((Object*)&right);
    _fieldName       = right._fieldName ;
    _typeName        = right._typeName  ;
    _affiliationClass= right._affiliationClass ;
    return *this;
  }
  inline void  Field::_finalize()
  {;}

  inline   Field::~Field()
  {
    this -> _finalize();
  }

  inline DBool Field::equals(const Object * o )
  {
    if(!findParent(_type,o))
      return false;
    return equals(*((Field*)o));
  }
  inline DBool Field::equals(const Field&   o )
  {
    DBool aBool   = (_fieldName       == o._fieldName) ;
    aBool        |= (_typeName        == o._typeName ) ;
    aBool        |= (_affiliationClass== o._affiliationClass) ;
    return aBool;
  }
  inline void Field::_setType()
  {
    this -> _type = "Field";
  }
  inline void Field::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("PubliclyCloneable");
    _parentClasses.insert("Serializable");
    _parentClasses.insert("SerializableObject");
  }
  inline  const DString&  Field::getFieldName() const 
  {
	return this -> _fieldName;
  }    
  
  inline  const DString&  Field::getTypeName() const 
  {
    return this -> _typeName;
  }    
  
  inline  void                Field::setAffiliationClassName( const DString& affiliationClassName)
  {
    this ->_affiliationClass = affiliationClassName;
  }
  

  inline  const DString&  Field::getAffiliationClassName() const 
  {
    return this ->_affiliationClass;
  }    
}
#endif
