#include <Class/DAQBuilderMethod.hh>
#include <System/IO/DAQBuilderByteArrayOutputStream.hh>
#include <System/IO/DAQBuilderPrimitiveDataOutputStream.hh>
#include <System/IO/DAQBuilderByteArrayInputStream.hh>
#include <System/IO/DAQBuilderPrimitiveDataInputStream.hh>

namespace DAQBuilder
{
  const DString  Method::toString() const 
  {
    DString returnString = "ReturnType: ";
    returnString += this -> getReturnTypeName();
    returnString += " Name: ";
    returnString += this -> getMethodName();
    returnString += "(";
    std::vector< std::pair<DString,DString> >::const_iterator iter = 
      this ->  getArgumentsTypesIterator(); 
    for(; iter !=  _argumentsNames.end() ; iter ++)
      {
        returnString +=" ";
        returnString +=iter->first;
        returnString +=":";
        returnString +=iter->second;
      }
    returnString += ")";
    returnString += " Class : ";
    returnString += this -> getAffiliationClassName();
    return returnString;
  }

  void                  Method::serialize( DByte *& data , DULong& dataSize )
  {
    ByteArrayOutputStream aBAO;   
    PrimitiveDataOutputStream aPDO(&aBAO);
    aPDO.writeString(_methodName);
    aPDO.writeString(_returnValueName);
    aPDO.writeString(_affiliationClass);
    for(    std::vector< std::pair<DString,DString> >::const_iterator iter =      
	      this ->  getArgumentsTypesIterator() 
	  ; iter !=  this->getArgumentsTypes().end() ; iter ++)
      {
         aPDO.writeString(iter->first);
         aPDO.writeString(iter->second);
      }
    return aBAO.toByteArray(data,dataSize);
  }
  ByteArray                  Method::serialize()
  {
    ByteArrayOutputStream aBAO;   
    PrimitiveDataOutputStream aPDO(&aBAO);
    aPDO.writeString(_methodName);
    aPDO.writeString(_returnValueName);
    aPDO.writeString(_affiliationClass);
    for(    std::vector< std::pair<DString,DString> >::const_iterator iter =      
	      _argumentsNames.begin()
	  ; iter !=  _argumentsNames.end() ; iter ++)
      {
         aPDO.writeString(iter->first);
         aPDO.writeString(iter->second);
      }
    return aBAO.toByteArray();
  }
  void                  Method::unSerialize( DByte * data , const DULong & dataSize )
  {
    ByteArrayInputStream     aBAI(data,dataSize);   
    PrimitiveDataInputStream aPDI(&aBAI);
    _methodName        = aPDI.readString();
    _returnValueName   = aPDI.readString();
    _affiliationClass  = aPDI.readString();
    _argumentsNames.clear();
    while(aBAI.available()!=0)
      {
	_argumentsNames.push_back( std::pair<DString,DString>(aPDI.readString(),aPDI.readString()) );
      }
  }

  Cloneable *                Method::clone() const 
  {
    return (Cloneable*) new Method(*this);
  }
  DBool   Method::operator   ==(const Method & right ) const 
  {
    DBool aBool = *((SerializableObject*)this) ==  *((SerializableObject*)&right);
    aBool |= _methodName==right._methodName;
    aBool |= _returnValueName==right._returnValueName;
    aBool |= _argumentsNames==right._argumentsNames;
    aBool |= _affiliationClass==right._affiliationClass;
    return aBool;
  }
  DBool   Method::operator   !=(const Method & right ) const 
  {
    DBool aBool = *((SerializableObject*)this) !=  *((SerializableObject*)&right);
    aBool |= _methodName!=right._methodName;
    aBool |= _returnValueName!=right._returnValueName;
    aBool |= _argumentsNames!=right._argumentsNames;
    aBool |= _affiliationClass!=right._affiliationClass;
    return aBool;
  }
}
