#ifndef _DAQBuilderMethod_HH
#define _DAQBuilderMethod_HH
#include <DAQBuilderSerializableObject.hh>
namespace DAQBuilder
{
  class  Method : public  SerializableObject
  {
  protected :
    DString                                    _methodName;
    DString                                    _returnValueName;
    DString                                    _affiliationClass;
    std::vector< std::pair<DString,DString> >  _argumentsNames;
  public :
    virtual void                       serialize(   DByte *& ,       DULong&  );
    virtual ByteArray                  serialize();
    virtual void                       unSerialize( DByte *  , const DULong&  );
    virtual Cloneable *                clone() const ;
  protected :
    virtual               void _finalize();
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  public :    
    virtual  const DString toString() const ;
    Method(); 
    Method( const DString& _methodName ,
	    const std::vector< std::pair<DString,DString> >& _argumentsNames , 
	    const DString& _returnValueName ,
	    const DString& _affiliationClass = "NoAffiliationClass");
    Method( const Method& right) ;
	 
    virtual ~Method();
    virtual DBool                          equals( const Object * o );
    virtual DBool                          equals( const Method & o );
  public:
    const DString&                         getMethodName() const ;
    void                                   setMethodName( const DString& _methodName );

    std::vector< std::pair<DString,DString> >&            getArgumentsTypes(); 
    void                                                  setArgumentsTypes(  const std::pair<DString,DString> & argumentType ); 
    std::vector< std::pair<DString,DString> >::const_iterator   getArgumentsTypesIterator() const ;
    DUInt                                  getNumberOfArguments() const ;

    const DString&                         getReturnTypeName() const ;
    void                                   setReturnTypeName( const DString& _returnValueName );

    void                                   setAffiliationClassName( const DString& affiliationClassName);
    const DString&                         getAffiliationClassName() const ;
    Method&                                operator=( const Method & right );
    virtual DBool   operator   ==(const Method & right ) const ;
    virtual DBool   operator   !=(const Method & right ) const ;
  };
  
  inline     void  Method::_finalize()
  {;}
    inline void Method::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("PubliclyCloneable");
    _parentClasses.insert("Serializable");
    _parentClasses.insert("SerializableObject");
  }
  inline  void               Method::_setType()
  {
    this -> _type="Method";
  }
  inline  Method::Method()  
    :SerializableObject()
  {
    this -> _setType();
    this -> _setParentClasses();
    }
  inline  Method::Method( const DString& methodName ,
			  const std::vector< std::pair<DString,DString> >& argumentsNames ,
			  const DString& returnValueName ,
			  const DString& affiliationClass)
    :SerializableObject(),_methodName(methodName),
     _returnValueName(returnValueName),_affiliationClass(affiliationClass),
     _argumentsNames(argumentsNames)
  {
    this -> _setType();
    this -> _setParentClasses();
  }
  inline  Method::Method( const Method& right)
    :SerializableObject(*((SerializableObject*)&right)),_methodName(right._methodName),
     _returnValueName(right._returnValueName),_affiliationClass(right._affiliationClass),
     _argumentsNames(right._argumentsNames)
  {
  }

  inline Method&  Method::operator=( const Method & right )
  {
    *((Object*)this) =     *((Object*)&right);
    _methodName      =right._methodName;
    _argumentsNames  =right._argumentsNames;
    _returnValueName =right._returnValueName;
    _affiliationClass=right._affiliationClass;
    return *this;
  }

  inline  Method::~Method()
  { 
    this -> _finalize();
  }

  inline DBool Method::equals(const Object * o )
  {
    if(!findParent(_type,o))
      return false;
    return equals(*((Method*)o));
  }
  inline DBool Method::equals(const Method&   o )
  {
    DBool aBool   = (_methodName      ==o._methodName);
    aBool        |= (_returnValueName ==o._returnValueName);
    aBool        |= (_affiliationClass== o._affiliationClass) ;

    if(_argumentsNames.size()!=o._argumentsNames.size())
      return false;

    for( DULong i=0; i< _argumentsNames.size(); i++)
      {
	aBool        |= (_argumentsNames[i]== o._argumentsNames[i]) ;
      }
    return aBool;
  }
  inline     const DString& Method::getMethodName() const 
  {
    return this -> _methodName;
  }    
  inline    void   Method::setMethodName( const DString& methodName )
  {
    _methodName  = methodName;
  } 
  inline std::vector< std::pair<DString,DString> >&            Method::getArgumentsTypes()
  {
    return _argumentsNames;
  } 
  inline void   Method::setArgumentsTypes( const std::pair<DString,DString> & argumentType )
  {
    _argumentsNames.push_back( argumentType );
  }
  inline  std::vector< std::pair<DString,DString> >::const_iterator  Method::getArgumentsTypesIterator() const 
  {
      return this ->_argumentsNames.begin();
  }      
  
  inline  void                Method::setAffiliationClassName( const DString& affiliationClassName)
  {
    this ->_affiliationClass.clear();
    this ->_affiliationClass = affiliationClassName;
  }
  
  inline  const DString&  Method::getAffiliationClassName() const 
  {
    return this ->_affiliationClass;
  }    
  
  inline  DUInt  Method::getNumberOfArguments() const 
  {
    return this -> _argumentsNames.size();
  }
  
  inline  const DString& Method::getReturnTypeName() const 
  {
    return this -> _returnValueName;
  }    
  inline    void   Method::setReturnTypeName( const DString& returnValueName )
  {
    _returnValueName  = returnValueName;
  } 
}
#endif
