#include<Run/DAQBuilderAction.hh>
#include<System/DAQBuilderSystem.hh>
#include<Instance/DAQBuilderInstance.hh>
#include<Primitives/DAQBuilderInteger.hh>
#include<Command/DAQBuilderActionCommand.hh>
namespace DAQBuilder
{
  ActionCommand::ActionCommand()
    :Command("[<returnValue>=]<object>.<method>(<args>...);")
  {
    _setType();
    _setParentClasses();
  }
  ActionCommand::ActionCommand( const ActionCommand& right )
    :Command(*((Command*)&right))
  {
    
  }
  ActionCommand::~ActionCommand()
  {
  }
  ActionCommand& ActionCommand::operator=( const ActionCommand & right)
  {
    *((Command*)this) = *((Command*)&right);
    return *this;
  }
  void ActionCommand::executeCommand( const StringList & arguments )
    throw (CommandException * )
  {
    DString aError;
    if(arguments.size() != 1 ){
      CommandException * e = 
	new CommandException("invalid number of arguments!");   
      e -> insert("Location","ActionCommand::operator()( const StringList& )");
      e -> insert("Usage : ","Action "+_help);
      throw e;
    }
    try{
      Action aAction = Action::compile(arguments[0]);
      aError = aAction.toString();
      aAction.execute();
    }catch (Exception * ex ){
     CommandException * e = 
	new CommandException("error occured");   
      e -> insert("Location","ActionCommand::operator()( const StringList& )");
      e -> insert("Error   : ",ex->toString());
      if(!aError.empty())
	e -> insert("Action  : ",aError);
      throw e;
    }
  }
}
