#include<Run/DAQBuilderAction.hh>
#include<System/DAQBuilderSystem.hh>
#include<System/DAQBuilderClassLoader.hh>
#include<System/DAQBuilderObjectRegistry.hh>
#include<Instance/DAQBuilderInstance.hh>
#include<Primitives/DAQBuilderInteger.hh>
#include<Command/DAQBuilderClearObjectRegistryCommand.hh>
namespace DAQBuilder
{
  ClearObjectRegistryCommand::ClearObjectRegistryCommand()
    :Command("")
  {
    _setType();
    _setParentClasses();
  }
  ClearObjectRegistryCommand::ClearObjectRegistryCommand( const ClearObjectRegistryCommand& right )
    :Command(*((Command*)&right))
  {
    
  }
  ClearObjectRegistryCommand::~ClearObjectRegistryCommand()
  {
  }
  ClearObjectRegistryCommand& ClearObjectRegistryCommand::operator=( const ClearObjectRegistryCommand & right)
  {
    *((Command*)this) = *((Command*)&right);
    return *this;
  }
  void ClearObjectRegistryCommand::executeCommand( const StringList & arguments )
    throw (CommandException * )
  {
    if(!arguments.empty())
      {
      CommandException * e = 
	new CommandException("invalid number of arguments!");   
      e -> insert("Location","ClearObjectRegistryCommand::operator()( const StringList& )");
      e -> insert("Usage : ","ClearObjectRegistry"+_help);
      throw e;
      }
    try{
      ObjectRegistry::clear();
    }catch (Exception * ex ){
      CommandException * e = 
	new CommandException("error occured");   
      e -> insert("Location","ClearObjectRegistryCommand::operator()( const StringList& )");
      e -> insert("Error   : ",ex->toString());
      throw e;
    }
  }
}
