#include <Command/DAQBuilderCommand.hh>

namespace DAQBuilder 
{
  Command::Command(  const DString& help )
    :Object(),_help(help)
  {
    _setType();
    _setParentClasses();
  }
  Command::Command( const Command& right )
    :Object(*((Object*)&right)),_help(right._help)
  {
   
  }
  Command::~Command()
  {
  }
  const DString     Command::toString() const
  {
    DString aString="Help";
    aString +=_help;
    return aString;
  }
  Command& Command::operator=( const Command & right)
 {
    *((Object*)this) = *((Object*)&right);
    _help = right._help;
    return *this;
 }
  DBool   Command::operator   ==(const Command & right ) const 
  {
    DBool aBool = *((Object*)this) ==  *((Object*)&right);
    aBool |= _help==right._help;
    return aBool;
  }
  DBool   Command::operator   !=(const Command & right ) const 
  {
    DBool aBool = *((Object*)this) !=  *((Object*)&right);
    aBool |= _help!=right._help;
    return aBool;
  }
}

