#ifndef _DAQBuilderBuilderCommand_HH_
#define _DAQBuilderBuilderCommand_HH_
#include <DAQBuilderObject.hh>
#include <Exception/DAQBuilderCommandException.hh>

namespace DAQBuilder 
{
  class Command : public Object 
  {
  protected:
      void              _setType();
      void              _setParentClasses();
   DString _help;
  public :
    Command( const DString& _help="NoHelp");
    Command( const Command& right );
    virtual ~Command();
  public:
    Command& operator           =( const Command & right);
    virtual DBool   operator   ==(const Command & right ) const ;
    virtual DBool   operator   !=(const Command & right ) const ;
  public:
    const DString     toString() const;
    virtual void executeCommand( const StringList & arguments )
      throw(CommandException *)=0;

    const DString& getHelp() const ;
  };
  inline void   Command::_setParentClasses()
  {
    _parentClasses.insert("Object");
  }
  inline void   Command::_setType()
  {
    this -> _type = "Command";
  }
  inline const DString& Command::getHelp() const 
  {
    return _help;
  }
}
#endif
