#ifndef __DAQBuilderCommands_HH__
#define __DAQBuilderCommands_HH__
#include <System/DAQBuilderCommandLoader.hh>
#include <Command/DAQBuilderShellCommand.hh>
#include <Command/DAQBuilderActionCommand.hh>
#include <Command/DAQBuilderDumpObjectCommand.hh>
#include <Command/DAQBuilderDumpRunCommand.hh>
#include <Command/DAQBuilderDumpActionCommand.hh>
#include <Command/DAQBuilderShowObjectRegistryCommand.hh> 
#include <Command/DAQBuilderShowActionRegistryCommand.hh> 
#include <Command/DAQBuilderShowRunRegistryCommand.hh> 
#include <Command/DAQBuilderCreateObjectCommand.hh>
#include <Command/DAQBuilderDeleteObjectCommand.hh>
#include <Command/DAQBuilderDeleteActionCommand.hh>
#include <Command/DAQBuilderDeleteRunCommand.hh>
#include <Command/DAQBuilderMacroCommand.hh>
#include <Command/DAQBuilderMakeActionCommand.hh>
#include <Command/DAQBuilderMakeRunCommand.hh>
#include <Command/DAQBuilderRunStartCommand.hh>
#include <Command/DAQBuilderRunShutdownCommand.hh>
#include <Command/DAQBuilderRunPauseCommand.hh>
#include <Command/DAQBuilderRunResumeCommand.hh>
#include <Command/DAQBuilderRunSetNumberOfEventsCommand.hh>
#include <Command/DAQBuilderInstallRunBeginActionCommand.hh>
#include <Command/DAQBuilderInstallRunLoopActionCommand.hh>
#include <Command/DAQBuilderInstallRunEndActionCommand.hh>
#include <Command/DAQBuilderClearObjectRegistryCommand.hh> 
#include <Command/DAQBuilderClearActionRegistryCommand.hh> 
#include <Command/DAQBuilderClearRunRegistryCommand.hh> 
namespace DAQBuilder
{
  CommandLoader _shellInsert( new ShellCommand() );
  CommandLoader _actionInsert( new ActionCommand() );
  CommandLoader _dumpObjectInsert( new DumpObjectCommand() );
  CommandLoader _dumpRunInsert( new DumpRunCommand() );
  CommandLoader _dumpActionInsert( new DumpActionCommand() );
  CommandLoader _createObjectInsert( new CreateObjectCommand() );
  CommandLoader _deleteObjectInsert( new DeleteObjectCommand() );
  CommandLoader _deleteActionInsert( new DeleteActionCommand() );
  CommandLoader _deleteRunInsert( new DeleteRunCommand() );
  CommandLoader _showObjectRegistryInsert( new ShowObjectRegistryCommand() );
  CommandLoader _showActionRegistryInsert( new ShowActionRegistryCommand() );
  CommandLoader _showRunRegistryInsert( new ShowRunRegistryCommand() );
  CommandLoader _macroInsert( new MacroCommand() );
  CommandLoader _makeActionInsert( new MakeActionCommand() );
  CommandLoader _makeRunInsert( new MakeRunCommand() );
  CommandLoader _runStartInsert( new RunStartCommand() );
  CommandLoader _runShutdownInsert( new RunShutdownCommand() );
  CommandLoader _runPauseInsert( new RunPauseCommand() );
  CommandLoader _runResumeInsert( new RunResumeCommand() );
  CommandLoader _runSetNumberOfEventsInsert( new RunSetNumberOfEventsCommand() );
  CommandLoader _installRunBeginActionInsert( new InstallRunBeginActionCommand() );
  CommandLoader _installRunLoopActionInsert( new InstallRunLoopActionCommand() );
  CommandLoader _installRunEndActionInsert( new InstallRunEndActionCommand() );
  CommandLoader _clearObjectRegistryInsert( new ClearObjectRegistryCommand() );
  CommandLoader _clearActionRegistryInsert( new ClearActionRegistryCommand() );
  CommandLoader _clearRunRegistryInsert( new ClearRunRegistryCommand() );
}
#endif
