#include<Run/DAQBuilderAction.hh>
#include<System/DAQBuilderSystem.hh>
#include<System/DAQBuilderClassLoader.hh>
#include<System/DAQBuilderObjectRegistry.hh>
#include<Instance/DAQBuilderInstance.hh>
#include<Primitives/DAQBuilderInteger.hh>
#include<Command/DAQBuilderCreateObjectCommand.hh>
namespace DAQBuilder
{
  CreateObjectCommand::CreateObjectCommand()
    :Command("<type> <objectName>")
  {
    _setType();
    _setParentClasses();
  }
  CreateObjectCommand::CreateObjectCommand( const CreateObjectCommand& right )
    :Command(*((Command*)&right))
  {
    
  }
  CreateObjectCommand::~CreateObjectCommand()
  {
  }
  CreateObjectCommand& CreateObjectCommand::operator=( const CreateObjectCommand & right)
  {
    *((Command*)this) = *((Command*)&right);
    return *this;
  }
  void CreateObjectCommand::executeCommand( const StringList & arguments )
    throw (CommandException * )
  {
    if(arguments.size() != 2 ){
      CommandException * e = 
	new CommandException("invalid number of arguments!");   
      e -> insert("Location","CreateObjectCommand::operator()( const StringList& )");
      e -> insert("Usage : ","CreateObject "+_help);
      throw e;
    }
    try{
      Instance aInstance = ClassLoader::getInstance(arguments[0]);
      aInstance.setObjectName( arguments[1] );
      ObjectRegistry::bind( aInstance );
    }catch (Exception * ex ){
      CommandException * e = 
	new CommandException("error occured");   
      e -> insert("Location","DeleteobjectCommand::operator()( const StringList& )");
      e -> insert("Error   : ",ex->toString());
      throw e;
    }
  }
}
