#include<Run/DAQBuilderAction.hh>
#include<System/DAQBuilderSystem.hh>
#include<System/DAQBuilderClassLoader.hh>
#include<System/DAQBuilderActionRegistry.hh>
#include<Instance/DAQBuilderInstance.hh>
#include<Primitives/DAQBuilderInteger.hh>
#include<Command/DAQBuilderDeleteActionCommand.hh>
namespace DAQBuilder
{
  DeleteActionCommand::DeleteActionCommand()
    :Command("<actionName>")
  {
    _setType();
    _setParentClasses();
  }
  DeleteActionCommand::DeleteActionCommand( const DeleteActionCommand& right )
    :Command(*((Command*)&right))
  {
    
  }
  DeleteActionCommand::~DeleteActionCommand()
  {
  }
  DeleteActionCommand& DeleteActionCommand::operator=( const DeleteActionCommand & right)
  {
    *((Command*)this) = *((Command*)&right);
    return *this;
  }
  void DeleteActionCommand::executeCommand( const StringList & arguments )
    throw (CommandException * )
  {
    if(arguments.size() != 1 ){
      CommandException * e = 
	new CommandException("invalid number of arguments!");   
      e -> insert("Location","DeleteActionCommand::operator()( const StringList& )");
      e -> insert("Usage : ","DeleteAction "+_help);
      throw e;
    }
    try{
      ActionRegistry::unbind( arguments[0] );
    }catch (Exception * ex ){
      CommandException * e = 
	new CommandException("error occured");   
      e -> insert("Location","DeleteobjectCommand::operator()( const StringList& )");
      e -> insert("Error   : ",ex->toString());
      throw e;
    }
  }
}
