#include<Run/DAQBuilderAction.hh>
#include<System/DAQBuilderSystem.hh>
#include<System/DAQBuilderClassLoader.hh>
#include<System/DAQBuilderObjectRegistry.hh>
#include<Instance/DAQBuilderInstance.hh>
#include<Primitives/DAQBuilderInteger.hh>
#include<Command/DAQBuilderDeleteObjectCommand.hh>
namespace DAQBuilder
{
  DeleteObjectCommand::DeleteObjectCommand()
    :Command("<objectName>")
  {
    _setType();
    _setParentClasses();
  }
  DeleteObjectCommand::DeleteObjectCommand( const DeleteObjectCommand& right )
    :Command(*((Command*)&right))
  {
    
  }
  DeleteObjectCommand::~DeleteObjectCommand()
  {
  }
  DeleteObjectCommand& DeleteObjectCommand::operator=( const DeleteObjectCommand & right)
  {
    *((Command*)this) = *((Command*)&right);
    return *this;
  }
  void DeleteObjectCommand::executeCommand( const StringList & arguments )
    throw (CommandException * )
  {
    if(arguments.size() != 1 ){
      CommandException * e = 
	new CommandException("invalid number of arguments!");   
      e -> insert("Location","DeleteObjectCommand::operator()( const StringList& )");
      e -> insert("Usage : ","DeleteObject "+_help);
      throw e;
    }
    try{
      ObjectRegistry::unbind( arguments[0] );
    }catch (Exception * ex ){
      CommandException * e = 
	new CommandException("error occured");   
      e -> insert("Location","DeleteobjectCommand::operator()( const StringList& )");
      e -> insert("Error   : ",ex->toString());
      throw e;
    }
  }
}
