#include<Run/DAQBuilderAction.hh>
#include<System/DAQBuilderSystem.hh>
#include<System/DAQBuilderClassLoader.hh>
#include<System/DAQBuilderActionRegistry.hh>
#include<Instance/DAQBuilderInstance.hh>
#include<Primitives/DAQBuilderInteger.hh>
#include<Command/DAQBuilderDumpActionCommand.hh>
namespace DAQBuilder
{
  DumpActionCommand::DumpActionCommand()
    :Command("<actionName>")
  {
    _setType();
    _setParentClasses();
  }
  DumpActionCommand::DumpActionCommand( const DumpActionCommand& right )
    :Command(*((Command*)&right))
  {
    
  }
  DumpActionCommand::~DumpActionCommand()
  {
  }
  DumpActionCommand& DumpActionCommand::operator=( const DumpActionCommand & right)
  {
    *((Command*)this) = *((Command*)&right);
    return *this;
  }
  void DumpActionCommand::executeCommand( const StringList & arguments )
    throw (CommandException * )
  {
    if(arguments.size() < 1 )
      {
      CommandException * e = 
	new CommandException("invalid number of arguments!");   
      e -> insert("Location","DumpActionCommand::operator()( const StringList& )");
      e -> insert("Usage : ","DumpAction "+_help);
      throw e;
      }
    try{
      System::out.println((Object&)ActionRegistry::lookUp( arguments[0] ));
    }catch (Exception * ex ){
      CommandException * e = 
	new CommandException("error occured");   
      e -> insert("Location","DumpActionCommand::operator()( const StringList& )");
      e -> insert("Error   : ",ex->toString());
      throw e;
    }
  }
}
