#include<Run/DAQBuilderAction.hh>
#include<System/DAQBuilderSystem.hh>
#include<System/DAQBuilderClassLoader.hh>
#include<System/DAQBuilderObjectRegistry.hh>
#include<Instance/DAQBuilderInstance.hh>
#include<Primitives/DAQBuilderInteger.hh>
#include<Command/DAQBuilderDumpObjectCommand.hh>
namespace DAQBuilder
{
  DumpObjectCommand::DumpObjectCommand()
    :Command("<objectName>")
  {
    _setType();
    _setParentClasses();
  }
  DumpObjectCommand::DumpObjectCommand( const DumpObjectCommand& right )
    :Command(*((Command*)&right))
  {
    
  }
  DumpObjectCommand::~DumpObjectCommand()
  {
  }
  DumpObjectCommand& DumpObjectCommand::operator=( const DumpObjectCommand & right)
  {
    *((Command*)this) = *((Command*)&right);
    return *this;
  }
  void DumpObjectCommand::executeCommand( const StringList & arguments )
    throw (CommandException * )
  {
    if(arguments.size() < 1 )
      {
      CommandException * e = 
	new CommandException("invalid number of arguments!");   
      e -> insert("Location","DumpObjectCommand::operator()( const StringList& )");
      e -> insert("Usage : ","DumpObject "+_help);
      throw e;
      }
    try{
      System::out.println(ObjectRegistry::lookUp( arguments[0] ));
    }catch (Exception * ex ){
      CommandException * e = 
	new CommandException("error occured");   
      e -> insert("Location","DumpObjectCommand::operator()( const StringList& )");
      e -> insert("Error   : ",ex->toString());
      throw e;
    }
  }
}
