#include<Run/DAQBuilderAction.hh>
#include<System/DAQBuilderSystem.hh>
#include<System/DAQBuilderClassLoader.hh>
#include<System/DAQBuilderRunRegistry.hh>
#include<Instance/DAQBuilderInstance.hh>
#include<Primitives/DAQBuilderInteger.hh>
#include<Command/DAQBuilderDumpRunCommand.hh>
namespace DAQBuilder
{
  DumpRunCommand::DumpRunCommand()
    :Command("<runName>")
  {
    _setType();
    _setParentClasses();
  }
  DumpRunCommand::DumpRunCommand( const DumpRunCommand& right )
    :Command(*((Command*)&right))
  {
    
  }
  DumpRunCommand::~DumpRunCommand()
  {
  }
  DumpRunCommand& DumpRunCommand::operator=( const DumpRunCommand & right)
  {
    *((Command*)this) = *((Command*)&right);
    return *this;
  }
  void DumpRunCommand::executeCommand( const StringList & arguments )
    throw (CommandException * )
  {
    if(arguments.size() < 1 )
      {
      CommandException * e = 
	new CommandException("invalid number of arguments!");   
      e -> insert("Location","DumpRunCommand::operator()( const StringList& )");
      e -> insert("Usage : ","DumpRun "+_help);
      throw e;
      }
    try{
      System::out.println((Object&)RunRegistry::lookUp( arguments[0] ));
    }catch (Exception * ex ){
      CommandException * e = 
	new CommandException("error occured");   
      e -> insert("Location","DumpRunCommand::operator()( const StringList& )");
      e -> insert("Error   : ",ex->toString());
      throw e;
    }
  }
}
