#include<Command/DAQBuilderInstallRunBeginActionCommand.hh>
#include<System/DAQBuilderRunRegistry.hh>
#include<System/DAQBuilderActionRegistry.hh>
#include<Run/DAQBuilderRun.hh>
#include<Run/DAQBuilderAction.hh>
#include<System/DAQBuilderSystem.hh>
#include<Primitives/DAQBuilderString.hh>
namespace DAQBuilder
{
  InstallRunBeginActionCommand::InstallRunBeginActionCommand()
    :Command("<runName> <actionName> | [<returnValue>=]<object>.(<args>...);")
  {
    _setType();
    _setParentClasses();
  }
  InstallRunBeginActionCommand::InstallRunBeginActionCommand( const InstallRunBeginActionCommand& right )
    :Command(*((Command*)&right))
  {
    
  }
  InstallRunBeginActionCommand::~InstallRunBeginActionCommand()
  {
  }
  InstallRunBeginActionCommand& InstallRunBeginActionCommand::operator=( const InstallRunBeginActionCommand & right)
  {
    *((Command*)this) = *((Command*)&right);
    return *this;
  }
  void InstallRunBeginActionCommand::executeCommand( const StringList & arguments )
    throw (CommandException * )
  {
    if(arguments.size() != 2 ){
      CommandException * e = 
	new CommandException("invalid number of arguments!");   
      e -> insert("Location","InstallRunBeginActionCommand::operator()( const StringList& )");
      e -> insert("Usage : ","InstallRunBeginAction "+_help);
      throw e;
    }
    DBool isAction = true;
    try{
      Action aAction = Action::compile(arguments[1]);
      (RunRegistry::lookUp(arguments[0])).addBeginAction(aAction);
    }catch(PatternSyntaxException *ex ){
       delete ex;
       isAction = false;
    }
    if(isAction)
       return;
    try{
      (RunRegistry::lookUp(arguments[0])).addBeginAction(ActionRegistry::lookUp(arguments[1]));
    }catch (Exception * ex ){
      CommandException * e = 
	new CommandException("error occured");   
      e -> insert("Location","InstallRunBeginActionCommand::operator()( const StringList& )");
      e -> insert("Error   : ",ex->toString());
      throw e;
    }
  }
}
