#include<Command/DAQBuilderInstallRunEndActionCommand.hh>
#include<System/DAQBuilderRunRegistry.hh>
#include<System/DAQBuilderActionRegistry.hh>
#include<Run/DAQBuilderRun.hh>
#include<Run/DAQBuilderAction.hh>
#include<System/DAQBuilderSystem.hh>
#include<Primitives/DAQBuilderString.hh>
namespace DAQBuilder
{
  InstallRunEndActionCommand::InstallRunEndActionCommand()
    :Command("<runName> <actionName> | [<returnValue>=]<object>.(<args>...);")
  {
    _setType();
    _setParentClasses();
  }
  InstallRunEndActionCommand::InstallRunEndActionCommand( const InstallRunEndActionCommand& right )
    :Command(*((Command*)&right))
  {
    
  }
  InstallRunEndActionCommand::~InstallRunEndActionCommand()
  {
  }
  InstallRunEndActionCommand& InstallRunEndActionCommand::operator=( const InstallRunEndActionCommand & right)
  {
    *((Command*)this) = *((Command*)&right);
    return *this;
  }
  void InstallRunEndActionCommand::executeCommand( const StringList & arguments )
    throw (CommandException * )
  {
    if(arguments.size() != 2 ){
      CommandException * e = 
	new CommandException("invalid number of arguments!");   
      e -> insert("Location","InstallRunEndActionCommand::operator()( const StringList& )");
      e -> insert("Usage : ","InstallRunEndAction "+_help);
      throw e;
    }
    DBool isAction=true;
    try{
      Action aAction = Action::compile(arguments[1]);
      (RunRegistry::lookUp(arguments[0])).addEndAction(aAction);
    }catch(PatternSyntaxException *ex ){
       delete ex;
       isAction = false;
    }
    if(isAction)
       return;
    try{
      (RunRegistry::lookUp(arguments[0])).addEndAction(ActionRegistry::lookUp(arguments[1]));
    }catch (Exception * ex ){
      CommandException * e = 
	new CommandException("error occured");   
      e -> insert("Location","InstallRunEndActionCommand::operator()( const StringList& )");
      e -> insert("Error   : ",ex->toString());
      throw e;
    }
  }
}
