#include<Command/DAQBuilderInstallRunLoopActionCommand.hh>
#include<System/DAQBuilderRunRegistry.hh>
#include<System/DAQBuilderActionRegistry.hh>
#include<Run/DAQBuilderRun.hh>
#include<Run/DAQBuilderAction.hh>
#include<System/DAQBuilderSystem.hh>
#include<Primitives/DAQBuilderString.hh>
namespace DAQBuilder
{
  InstallRunLoopActionCommand::InstallRunLoopActionCommand()
    :Command("<runName> <actionName> | [<returnValue>=]<object>.(<args>...);")
  {
    _setType();
    _setParentClasses();
  }
  InstallRunLoopActionCommand::InstallRunLoopActionCommand( const InstallRunLoopActionCommand& right )
    :Command(*((Command*)&right))
  {
    
  }
  InstallRunLoopActionCommand::~InstallRunLoopActionCommand()
  {
  }
  InstallRunLoopActionCommand& InstallRunLoopActionCommand::operator=( const InstallRunLoopActionCommand & right)
  {
    *((Command*)this) = *((Command*)&right);
    return *this;
  }
  void InstallRunLoopActionCommand::executeCommand( const StringList & arguments )
    throw (CommandException * )
  {
    if(arguments.size() != 2 ){
      CommandException * e = 
	new CommandException("invalid number of arguments!");   
      e -> insert("Location","InstallRunLoopActionCommand::operator()( const StringList& )");
      e -> insert("Usage : ","InstallRunLoopAction "+_help);
      throw e;
    }
    DBool isAction=true;
    try{
      Action aAction = Action::compile(arguments[1]);
      (RunRegistry::lookUp(arguments[0])).addLoopAction(aAction);
    }catch(PatternSyntaxException *ex ){
       delete ex;
       isAction = false;
    }
    if(isAction)
       return;
    try{
      (RunRegistry::lookUp(arguments[0])).addLoopAction(ActionRegistry::lookUp(arguments[1]));
    }catch (Exception * ex ){
      CommandException * e = 
	new CommandException("error occured");   
      e -> insert("Location","InstallRunLoopActionCommand::operator()( const StringList& )");
      e -> insert("Error   : ",ex->toString());
      throw e;
    }
  }
}
