#include<Run/DAQBuilderAction.hh>
#include<System/DAQBuilderSystem.hh>
#include<System/DAQBuilderClassLoader.hh>
#include<System/DAQBuilderObjectRegistry.hh>
#include<Instance/DAQBuilderInstance.hh>
#include<Primitives/DAQBuilderInteger.hh>
#include<Command/DAQBuilderMacroCommand.hh>
#include<Util/DAQBuilderCommentEraser.hh>
namespace DAQBuilder
{
  MacroCommand::MacroCommand()
    :Command("<macroFileName>")
  {
    _setType();
    _setParentClasses();
  }
  MacroCommand::MacroCommand( const MacroCommand& right )
    :Command(*((Command*)&right))
  {
    
  }
  MacroCommand::~MacroCommand()
  {
  }
  MacroCommand& MacroCommand::operator=( const MacroCommand & right)
  {
    *((Command*)this) = *((Command*)&right);
    return *this;
  }
  void MacroCommand::executeCommand( const StringList & arguments )
    throw (CommandException * )
  {
   if(arguments.size() != 1 ){
      CommandException * e = 
	new CommandException("invalid number of arguments!");   
      e -> insert("Location","MacroCommand::operator()( const StringList& )");
      e -> insert("Usage : ","Macro "+_help);
      throw e;
    }

      StringList macroCommand ;
      macroCommand.clear();
      std::ifstream macroFile(arguments[0].c_str());
      if(!macroFile.is_open()||macroFile.fail())
	throw new CommandException("void MacroCommand::operator()( const StringList& ) can't open File : "+arguments[0]);   
      try{
	  while(!macroFile.eof())
	    {
	      DString tmpLine;
	      char buf[128];
	      macroFile.getline(buf,128);
	      tmpLine = buf;
	      CommentEraser eraser;
              //std::cout<<"tmpLine="<<tmpLine<<std::endl;
	      tmpLine  = eraser.result(tmpLine);
	      if(!tmpLine.empty()){
          //    std::cout<<"tmpLine="<<tmpLine<<std::endl;
	       macroCommand.push_back(tmpLine);
	       }
	    }
	  macroFile.close();
	  //macroCommand.pop_back();
	  for(std::vector<std::string>::const_iterator iter = macroCommand.begin();
	      iter != macroCommand.end() ;
	      iter++)
	    {
           //   std::cout<<"tmpLine="<<*iter<<std::endl;
	      System::out.println(*iter);
	      System::command.println(*iter);
	    }
      }catch (Exception * ex ){
	CommandException * e = 
	  new CommandException("error occured");   
	e -> insert("Location","MacroCommand::operator()( const StringList& )");
	e -> insert("Error   : ",ex->toString());
      throw e;
    }
  }
}
