#ifndef _DAQBuilderBuilderMacroCommand_HH_
#define _DAQBuilderBuilderMacroCommand_HH_
#include <Command/DAQBuilderCommand.hh>

namespace DAQBuilder 
{
  class MacroCommand : public Command
  {
  protected:
      void              _setType();
      void              _setParentClasses();
  public :
    MacroCommand();
    MacroCommand( const MacroCommand& right );
    virtual ~MacroCommand();
    MacroCommand& operator=( const MacroCommand & right);
  public:
    void executeCommand( const StringList & arguments )
      throw(CommandException *);
  };
  inline void   MacroCommand::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("Command");
  }
  inline void   MacroCommand::_setType()
  {
    this -> _type = "MacroCommand";
  }
}
#endif
