#include<Command/DAQBuilderMakeActionCommand.hh>
#include<System/DAQBuilderActionRegistry.hh>
#include<Run/DAQBuilderAction.hh>
#include<System/DAQBuilderSystem.hh>
namespace DAQBuilder
{
  MakeActionCommand::MakeActionCommand()
    :Command("<actionName> [<returnValue>=]<object>.<method>(<args>...);")
  {
    _setType();
    _setParentClasses();
  }
  MakeActionCommand::MakeActionCommand( const MakeActionCommand& right )
    :Command(*((Command*)&right))
  {
    
  }
  MakeActionCommand::~MakeActionCommand()
  {
  }
  MakeActionCommand& MakeActionCommand::operator=( const MakeActionCommand & right)
  {
    *((Command*)this) = *((Command*)&right);
    return *this;
  }
  void MakeActionCommand::executeCommand( const StringList & arguments )
    throw (CommandException * )
  {
    if(arguments.size() != 2 ){
      CommandException * e = 
	new CommandException("invalid number of arguments!");   
      e -> insert("Location","MakeActionCommand::operator()( const StringList& )");
      e -> insert("Usage : ","MakeAction "+_help);
      throw e;
    }
    try{
      Action aAction = Action::compile(arguments[1]);
      ActionRegistry::bind(arguments[0],aAction);
    }catch (Exception * ex ){
      CommandException * e = 
	new CommandException("error occured");   
      e -> insert("Location","MakeActionCommand::operator()( const StringList& )");
      e -> insert("Error   : ",ex->toString());
      throw e;
    }
  }
}

